/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.servicecommon.rest;

import io.helidon.config.Config;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.Service;
import io.helidon.webserver.cors.CorsEnabledServiceHelper;
import io.helidon.webserver.cors.CrossOriginConfig;
import java.util.Objects;
import java.util.logging.Logger;

public abstract class HelidonRestServiceSupport
implements Service {
    private final String context;
    private final CorsEnabledServiceHelper corsEnabledServiceHelper;
    private final Logger logger;

    protected HelidonRestServiceSupport(Logger logger, Builder<?, ?> builder, String serviceName) {
        this.logger = logger;
        this.context = builder.context;
        this.corsEnabledServiceHelper = CorsEnabledServiceHelper.create((String)serviceName, (CrossOriginConfig)builder.crossOriginConfig);
    }

    public final void configureEndpoint(Routing.Rules rules) {
        rules.any(this.context, new Handler[]{this.corsEnabledServiceHelper.processor()});
        this.postConfigureEndpoint(rules);
    }

    protected abstract void postConfigureEndpoint(Routing.Rules var1);

    protected String context() {
        return this.context;
    }

    protected Logger logger() {
        return this.logger;
    }

    public static abstract class Builder<T extends HelidonRestServiceSupport, B extends Builder<T, B>>
    implements io.helidon.common.Builder<T> {
        private final Class<B> builderClass;
        private String context;
        private Config config = Config.empty();
        private CrossOriginConfig crossOriginConfig = null;

        protected Builder(Class<B> builderClass, String defaultContext) {
            this.builderClass = builderClass;
            this.context = defaultContext;
        }

        public B config(Config config) {
            this.config = config;
            this.webContextConfig(config).asString().ifPresent(this::webContext);
            config.get("cors").as(CrossOriginConfig::create).ifPresent(this::crossOriginConfig);
            return this.me();
        }

        public Config config() {
            return this.config;
        }

        public B webContext(String path) {
            this.context = path.startsWith("/") ? path : "/" + path;
            return this.me();
        }

        public B crossOriginConfig(CrossOriginConfig crossOriginConfig) {
            Objects.requireNonNull(crossOriginConfig, "CrossOriginConfig must be non-null");
            this.crossOriginConfig = crossOriginConfig;
            return this.me();
        }

        protected B me() {
            return (B)((Builder)this.builderClass.cast(this));
        }

        protected Config webContextConfig(Config config) {
            return config.get("web-context");
        }
    }
}

