/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.servicecommon.rest;

import io.helidon.config.Config;
import io.helidon.servicecommon.rest.RestServiceSettings;
import io.helidon.servicecommon.rest.RestServiceSupport;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.cors.CorsEnabledServiceHelper;
import io.helidon.webserver.cors.CrossOriginConfig;
import java.util.Objects;
import java.util.logging.Logger;

public abstract class HelidonRestServiceSupport
implements RestServiceSupport {
    private final String context;
    private final CorsEnabledServiceHelper corsEnabledServiceHelper;
    private final Logger logger;
    private int webServerCount;

    protected HelidonRestServiceSupport(Logger logger, Builder<?, ?> builder, String serviceName) {
        this(logger, builder.restServiceSettingsBuilder.build(), serviceName);
    }

    protected HelidonRestServiceSupport(Logger logger, RestServiceSettings restServiceSettings, String serviceName) {
        this.logger = logger;
        this.corsEnabledServiceHelper = CorsEnabledServiceHelper.create((String)serviceName, (CrossOriginConfig)restServiceSettings.crossOriginConfig());
        this.context = (restServiceSettings.webContext().startsWith("/") ? "" : "/") + restServiceSettings.webContext();
    }

    @Deprecated
    public final void configureEndpoint(Routing.Rules rules) {
        this.configureEndpoint(rules, rules);
    }

    @Override
    public final void configureEndpoint(Routing.Rules defaultRules, Routing.Rules serviceEndpointRoutingRules) {
        defaultRules.onNewWebServer(webserver -> {
            this.webServerStarted();
            webserver.whenShutdown().thenRun(this::webServerStopped);
        });
        defaultRules.any(this.context, new Handler[]{this.corsEnabledServiceHelper.processor()});
        if (defaultRules != serviceEndpointRoutingRules) {
            serviceEndpointRoutingRules.any(this.context, new Handler[]{this.corsEnabledServiceHelper.processor()});
        }
        this.postConfigureEndpoint(defaultRules, serviceEndpointRoutingRules);
    }

    protected abstract void postConfigureEndpoint(Routing.Rules var1, Routing.Rules var2);

    private void webServerStarted() {
        ++this.webServerCount;
    }

    private void webServerStopped() {
        if (--this.webServerCount == 0) {
            this.onShutdown();
        }
    }

    protected void onShutdown() {
    }

    protected String context() {
        return this.context;
    }

    protected Logger logger() {
        return this.logger;
    }

    public static abstract class Builder<T extends HelidonRestServiceSupport, B extends Builder<T, B>>
    implements io.helidon.common.Builder<T> {
        private final Class<B> builderClass;
        private Config config = Config.empty();
        private RestServiceSettings.Builder restServiceSettingsBuilder = RestServiceSettings.builder();

        protected Builder(Class<B> builderClass, String defaultContext) {
            this.builderClass = builderClass;
            this.restServiceSettingsBuilder.webContext(defaultContext);
        }

        public B config(Config config) {
            this.config = config;
            this.webContextConfig(config).asString().ifPresent(this::webContext);
            config.get("routing").asString().ifPresent(this.restServiceSettingsBuilder::routing);
            config.get("cors").as(CrossOriginConfig::create).ifPresent(this::crossOriginConfig);
            return this.me();
        }

        public Config config() {
            return this.config;
        }

        public B webContext(String path) {
            Object context = path.startsWith("/") ? path : "/" + path;
            this.restServiceSettingsBuilder.webContext((String)context);
            return this.me();
        }

        public B crossOriginConfig(CrossOriginConfig crossOriginConfig) {
            Objects.requireNonNull(crossOriginConfig, "CrossOriginConfig must be non-null");
            this.restServiceSettingsBuilder.crossOriginConfig(crossOriginConfig);
            return this.me();
        }

        public B restServiceSettings(RestServiceSettings.Builder restServiceSettingsBuilder) {
            this.restServiceSettingsBuilder = restServiceSettingsBuilder;
            return this.me();
        }

        protected B me() {
            return (B)((Builder)this.builderClass.cast(this));
        }

        protected Config webContextConfig(Config config) {
            return config.get("web-context");
        }
    }
}

