/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.servicecommon.rest;

import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.servicecommon.rest.RestServiceSettings;
import io.helidon.servicecommon.rest.RestServiceSupport;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.cors.CorsEnabledServiceHelper;
import io.helidon.webserver.cors.CrossOriginConfig;
import java.util.Objects;
import java.util.logging.Logger;

public abstract class HelidonRestServiceSupport
implements RestServiceSupport {
    private final String context;
    private final CorsEnabledServiceHelper corsEnabledServiceHelper;
    private final Logger logger;
    private int webServerCount;

    protected HelidonRestServiceSupport(Logger logger, Builder<?, ?> builder, String serviceName) {
        this(logger, builder.restServiceSettingsBuilder.build(), serviceName);
    }

    protected HelidonRestServiceSupport(Logger logger, RestServiceSettings restServiceSettings, String serviceName) {
        this.logger = logger;
        this.corsEnabledServiceHelper = CorsEnabledServiceHelper.create((String)serviceName, (CrossOriginConfig)restServiceSettings.crossOriginConfig());
        this.context = (restServiceSettings.webContext().startsWith("/") ? "" : "/") + restServiceSettings.webContext();
    }

    @Override
    public final void configureEndpoint(Routing.Rules defaultRules, Routing.Rules serviceEndpointRoutingRules) {
        defaultRules.onNewWebServer(webserver -> {
            this.webServerStarted();
            webserver.whenShutdown().thenRun(this::webServerStopped);
        });
        defaultRules.any(this.context, new Handler[]{this.corsEnabledServiceHelper.processor()});
        if (defaultRules != serviceEndpointRoutingRules) {
            serviceEndpointRoutingRules.any(this.context, new Handler[]{this.corsEnabledServiceHelper.processor()});
        }
        this.postConfigureEndpoint(defaultRules, serviceEndpointRoutingRules);
    }

    protected abstract void postConfigureEndpoint(Routing.Rules var1, Routing.Rules var2);

    private void webServerStarted() {
        ++this.webServerCount;
    }

    private void webServerStopped() {
        if (--this.webServerCount == 0) {
            this.onShutdown();
        }
    }

    protected void onShutdown() {
    }

    protected String context() {
        return this.context;
    }

    protected Logger logger() {
        return this.logger;
    }

    @Configured
    public static abstract class Builder<B extends Builder<B, T>, T extends HelidonRestServiceSupport>
    implements io.helidon.common.Builder<B, T> {
        private Config config = Config.empty();
        private RestServiceSettings.Builder restServiceSettingsBuilder = RestServiceSettings.builder();

        protected Builder(String defaultContext) {
            this.restServiceSettingsBuilder.webContext(defaultContext);
        }

        public B config(Config config) {
            this.config = config;
            this.restServiceSettingsBuilder.config(config);
            config.get("cors").as(CrossOriginConfig::create).ifPresent(this::crossOriginConfig);
            return (B)((Builder)this.identity());
        }

        public Config config() {
            return this.config;
        }

        public B webContext(String path) {
            Object context = path.startsWith("/") ? path : "/" + path;
            this.restServiceSettingsBuilder.webContext((String)context);
            return (B)((Builder)this.identity());
        }

        public B crossOriginConfig(CrossOriginConfig crossOriginConfig) {
            Objects.requireNonNull(crossOriginConfig, "CrossOriginConfig must be non-null");
            this.restServiceSettingsBuilder.crossOriginConfig(crossOriginConfig);
            return (B)((Builder)this.identity());
        }

        public B crossOriginConfig(CrossOriginConfig.Builder crossOriginConfigBuilder) {
            Objects.requireNonNull(crossOriginConfigBuilder, "CrossOriginConfig.Builder must be non-null");
            this.restServiceSettingsBuilder.crossOriginConfig(crossOriginConfigBuilder);
            return (B)((Builder)this.identity());
        }

        public B restServiceSettings(RestServiceSettings.Builder restServiceSettingsBuilder) {
            this.restServiceSettingsBuilder = restServiceSettingsBuilder;
            return (B)((Builder)this.identity());
        }

        protected Config webContextConfig(Config config) {
            return config.get("web-context");
        }
    }
}

