/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.codegen;

import io.helidon.common.types.ElementKind;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.service.codegen.DescribedElements;
import java.util.Objects;
import java.util.Set;

public class DescribedType {
    private final TypeInfo typeInfo;
    private final boolean isAbstract;
    private final TypeName typeName;
    private final Set<ResolvedType> contracts;
    private final DescribedElements elements;

    DescribedType(TypeInfo typeInfo, TypeName typeName, Set<ResolvedType> contracts, DescribedElements elements) {
        Objects.requireNonNull(typeInfo);
        Objects.requireNonNull(typeName);
        Objects.requireNonNull(contracts);
        Objects.requireNonNull(elements);
        this.typeInfo = typeInfo;
        this.isAbstract = DescribedType.isAbstract(typeInfo);
        this.typeName = typeName;
        this.contracts = contracts;
        this.elements = elements;
    }

    boolean isAbstract() {
        return this.isAbstract;
    }

    TypeInfo typeInfo() {
        return this.typeInfo;
    }

    TypeName typeName() {
        return this.typeName;
    }

    Set<ResolvedType> contracts() {
        return this.contracts;
    }

    DescribedElements elements() {
        return this.elements;
    }

    private static boolean isAbstract(TypeInfo typeInfo) {
        if (typeInfo == null) {
            return false;
        }
        if (typeInfo.kind() == ElementKind.CLASS) {
            return typeInfo.elementModifiers().contains(Modifier.ABSTRACT);
        }
        return typeInfo.kind() == ElementKind.INTERFACE;
    }
}

