/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.metadata;

import io.helidon.metadata.hson.Hson;
import io.helidon.service.metadata.DescriptorMetadata;
import io.helidon.service.metadata.DescriptorMetadataImpl;
import java.util.ArrayList;
import java.util.List;

public class Descriptors {
    public static final String SERVICE_REGISTRY_LOCATION = "META-INF/helidon/service-registry.json";
    private static final int CURRENT_REGISTRY_VERSION = 1;
    private static final int DEFAULT_REGISTRY_VERSION = 1;

    private Descriptors() {
    }

    public static List<DescriptorMetadata> descriptors(String location, Hson.Array moduleRegistries) {
        ArrayList<DescriptorMetadata> descriptors = new ArrayList<DescriptorMetadata>();
        for (Hson.Struct moduleRegistry : moduleRegistries.getStructs()) {
            String moduleName = moduleRegistry.stringValue("module", "unknown");
            int version = moduleRegistry.intValue("version", 1);
            if (version != 1) {
                throw new IllegalStateException("Invalid registry version: " + version + " for module \"" + moduleName + "\" loaded from \"" + location + "\", expected version: \"1\"");
            }
            moduleRegistry.structArray("services").orElseGet(List::of).stream().map(it -> DescriptorMetadataImpl.create(moduleName, location, it)).forEach(descriptors::add);
        }
        return descriptors;
    }
}

