/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.GenericType;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.service.registry.Dependency;
import io.helidon.service.registry.FactoryType;
import io.helidon.service.registry.LookupBlueprint;
import io.helidon.service.registry.LookupSupport;
import io.helidon.service.registry.Qualifier;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.service.registry.LookupBlueprint")
public interface Lookup
extends LookupBlueprint,
Prototype.Api {
    public static final Lookup EMPTY = LookupSupport.CustomMethods.EMPTY;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Lookup instance) {
        return (Builder)Lookup.builder().from(instance);
    }

    public static Lookup create(Dependency dependency) {
        return LookupSupport.CustomMethods.create(dependency);
    }

    public static Lookup create(Class<?> contract) {
        return LookupSupport.CustomMethods.create(contract);
    }

    public static Lookup create(TypeName contract) {
        return LookupSupport.CustomMethods.create(contract);
    }

    @Override
    public Optional<TypeName> serviceType();

    @Override
    public Set<TypeName> scopes();

    @Override
    public Set<Qualifier> qualifiers();

    @Override
    public Set<ResolvedType> contracts();

    @Override
    public Optional<GenericType<?>> contractType();

    @Override
    public Optional<Double> runLevel();

    @Override
    public Optional<Double> weight();

    @Override
    public boolean includeAbstract();

    @Override
    public Optional<Dependency> dependency();

    @Override
    public Set<FactoryType> factoryTypes();

    public static class Builder
    extends BuilderBase<Builder, Lookup>
    implements io.helidon.common.Builder<Builder, Lookup> {
        private Builder() {
        }

        public Lookup buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.LookupImpl(this);
        }

        public Lookup build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Lookup>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private final Set<Qualifier> qualifiers = new LinkedHashSet<Qualifier>();
        private final Set<ResolvedType> contracts = new LinkedHashSet<ResolvedType>();
        private final Set<TypeName> scopes = new LinkedHashSet<TypeName>();
        private final Set<FactoryType> factoryTypes = new LinkedHashSet<FactoryType>();
        private boolean includeAbstract = false;
        private Dependency dependency;
        private Double runLevel;
        private Double weight;
        private GenericType<?> contractType;
        private TypeName serviceType;

        protected BuilderBase() {
        }

        public BUILDER from(Lookup prototype) {
            this.serviceType(prototype.serviceType());
            this.addScopes(prototype.scopes());
            this.addQualifiers(prototype.qualifiers());
            this.addContracts(prototype.contracts());
            this.contractType(prototype.contractType());
            this.runLevel(prototype.runLevel());
            this.weight(prototype.weight());
            this.includeAbstract(prototype.includeAbstract());
            this.dependency(prototype.dependency());
            this.addFactoryTypes(prototype.factoryTypes());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.serviceType().ifPresent(this::serviceType);
            this.addScopes(builder.scopes);
            this.addQualifiers(builder.qualifiers);
            this.addContracts(builder.contracts);
            builder.contractType().ifPresent(this::contractType);
            builder.runLevel().ifPresent(this::runLevel);
            builder.weight().ifPresent(this::weight);
            this.includeAbstract(builder.includeAbstract());
            builder.dependency().ifPresent(this::dependency);
            this.addFactoryTypes(builder.factoryTypes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContract(Class<?> contract) {
            LookupSupport.CustomMethods.addContract(this, contract);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContract(TypeName contract) {
            LookupSupport.CustomMethods.addContract(this, contract);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceType(Class<?> contract) {
            LookupSupport.CustomMethods.serviceType(this, contract);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER named(String name) {
            LookupSupport.CustomMethods.named(this, name);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER named(Class<?> clazz) {
            LookupSupport.CustomMethods.named(this, clazz);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearServiceType() {
            this.serviceType = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceType(TypeName serviceType) {
            Objects.requireNonNull(serviceType);
            this.serviceType = serviceType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER serviceType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.serviceType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER scopes(Set<? extends TypeName> scopes) {
            Objects.requireNonNull(scopes);
            this.scopes.clear();
            this.scopes.addAll(scopes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addScopes(Set<? extends TypeName> scopes) {
            Objects.requireNonNull(scopes);
            this.scopes.addAll(scopes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addScope(TypeName scope) {
            Objects.requireNonNull(scope);
            this.scopes.add(scope);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addScope(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.scopes.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER qualifiers(Set<? extends Qualifier> qualifiers) {
            Objects.requireNonNull(qualifiers);
            this.qualifiers.clear();
            this.qualifiers.addAll(qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifiers(Set<? extends Qualifier> qualifiers) {
            Objects.requireNonNull(qualifiers);
            this.qualifiers.addAll(qualifiers);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifier(Qualifier qualifier) {
            Objects.requireNonNull(qualifier);
            this.qualifiers.add(qualifier);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addQualifier(Consumer<Qualifier.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Qualifier.Builder builder = Qualifier.builder();
            consumer.accept(builder);
            this.qualifiers.add(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contracts(Set<? extends ResolvedType> contracts) {
            Objects.requireNonNull(contracts);
            this.contracts.clear();
            this.contracts.addAll(contracts);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContracts(Set<? extends ResolvedType> contracts) {
            Objects.requireNonNull(contracts);
            this.contracts.addAll(contracts);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addContract(ResolvedType contract) {
            Objects.requireNonNull(contract);
            this.contracts.add(contract);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearContractType() {
            new LookupSupport.GenericTypeDecorator().decorate(this, Optional.empty());
            this.contractType = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contractType(GenericType<?> contractType) {
            Objects.requireNonNull(contractType);
            new LookupSupport.GenericTypeDecorator().decorate(this, Optional.of(contractType));
            this.contractType = contractType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRunLevel() {
            this.runLevel = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER runLevel(double runLevel) {
            Objects.requireNonNull(runLevel);
            this.runLevel = runLevel;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearWeight() {
            this.weight = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER weight(double weight) {
            Objects.requireNonNull(weight);
            this.weight = weight;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER includeAbstract(boolean includeAbstract) {
            this.includeAbstract = includeAbstract;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDependency() {
            new LookupSupport.DependencyDecorator().decorate(this, Optional.empty());
            this.dependency = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER dependency(Dependency dependency) {
            Objects.requireNonNull(dependency);
            new LookupSupport.DependencyDecorator().decorate(this, Optional.of(dependency));
            this.dependency = dependency;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER dependency(Consumer<Dependency.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Dependency.Builder builder = Dependency.builder();
            consumer.accept(builder);
            this.dependency(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER factoryTypes(Set<? extends FactoryType> factoryTypes) {
            Objects.requireNonNull(factoryTypes);
            this.factoryTypes.clear();
            this.factoryTypes.addAll(factoryTypes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addFactoryTypes(Set<? extends FactoryType> factoryTypes) {
            Objects.requireNonNull(factoryTypes);
            this.factoryTypes.addAll(factoryTypes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addFactoryType(FactoryType factoryType) {
            Objects.requireNonNull(factoryType);
            this.factoryTypes.add(factoryType);
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<TypeName> serviceType() {
            return Optional.ofNullable(this.serviceType);
        }

        public Set<TypeName> scopes() {
            return this.scopes;
        }

        public Set<Qualifier> qualifiers() {
            return this.qualifiers;
        }

        public Set<ResolvedType> contracts() {
            return this.contracts;
        }

        public Optional<GenericType<?>> contractType() {
            return Optional.ofNullable(this.contractType);
        }

        public Optional<Double> runLevel() {
            return Optional.ofNullable(this.runLevel);
        }

        public Optional<Double> weight() {
            return Optional.ofNullable(this.weight);
        }

        public boolean includeAbstract() {
            return this.includeAbstract;
        }

        public Optional<Dependency> dependency() {
            return Optional.ofNullable(this.dependency);
        }

        public Set<FactoryType> factoryTypes() {
            return this.factoryTypes;
        }

        public String toString() {
            return "LookupBuilder{serviceType=" + String.valueOf(this.serviceType) + ",scopes=" + String.valueOf(this.scopes) + ",qualifiers=" + String.valueOf(this.qualifiers) + ",contracts=" + String.valueOf(this.contracts) + ",contractType=" + String.valueOf(this.contractType) + ",runLevel=" + this.runLevel + ",weight=" + this.weight + ",includeAbstract=" + this.includeAbstract + ",dependency=" + String.valueOf(this.dependency) + ",factoryTypes=" + String.valueOf(this.factoryTypes) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER serviceType(Optional<? extends TypeName> serviceType) {
            Objects.requireNonNull(serviceType);
            this.serviceType = serviceType.map(TypeName.class::cast).orElse(this.serviceType);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER contractType(Optional<GenericType<?>> contractType) {
            Objects.requireNonNull(contractType);
            this.contractType = contractType.map(GenericType.class::cast).orElse(this.contractType);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER runLevel(Optional<Double> runLevel) {
            Objects.requireNonNull(runLevel);
            this.runLevel = runLevel.map(Double.class::cast).orElse(this.runLevel);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER weight(Optional<Double> weight) {
            Objects.requireNonNull(weight);
            this.weight = weight.map(Double.class::cast).orElse(this.weight);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER dependency(Optional<? extends Dependency> dependency) {
            Objects.requireNonNull(dependency);
            this.dependency = dependency.map(Dependency.class::cast).orElse(this.dependency);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class LookupImpl
        implements Lookup {
            private final boolean includeAbstract;
            private final Optional<Dependency> dependency;
            private final Optional<GenericType<?>> contractType;
            private final Optional<TypeName> serviceType;
            private final Optional<Double> runLevel;
            private final Optional<Double> weight;
            private final Set<Qualifier> qualifiers;
            private final Set<ResolvedType> contracts;
            private final Set<TypeName> scopes;
            private final Set<FactoryType> factoryTypes;

            protected LookupImpl(BuilderBase<?, ?> builder) {
                this.serviceType = builder.serviceType().map(Function.identity());
                this.scopes = Collections.unmodifiableSet(new LinkedHashSet<TypeName>(builder.scopes()));
                this.qualifiers = Collections.unmodifiableSet(new LinkedHashSet<Qualifier>(builder.qualifiers()));
                this.contracts = Collections.unmodifiableSet(new LinkedHashSet<ResolvedType>(builder.contracts()));
                this.contractType = builder.contractType().map(Function.identity());
                this.runLevel = builder.runLevel().map(Function.identity());
                this.weight = builder.weight().map(Function.identity());
                this.includeAbstract = builder.includeAbstract();
                this.dependency = builder.dependency().map(Function.identity());
                this.factoryTypes = Collections.unmodifiableSet(new LinkedHashSet<FactoryType>(builder.factoryTypes()));
            }

            @Override
            public Optional<TypeName> serviceType() {
                return this.serviceType;
            }

            @Override
            public Set<TypeName> scopes() {
                return this.scopes;
            }

            @Override
            public Set<Qualifier> qualifiers() {
                return this.qualifiers;
            }

            @Override
            public Set<ResolvedType> contracts() {
                return this.contracts;
            }

            @Override
            public Optional<GenericType<?>> contractType() {
                return this.contractType;
            }

            @Override
            public Optional<Double> runLevel() {
                return this.runLevel;
            }

            @Override
            public Optional<Double> weight() {
                return this.weight;
            }

            @Override
            public boolean includeAbstract() {
                return this.includeAbstract;
            }

            @Override
            public Optional<Dependency> dependency() {
                return this.dependency;
            }

            @Override
            public Set<FactoryType> factoryTypes() {
                return this.factoryTypes;
            }

            public String toString() {
                return "Lookup{serviceType=" + String.valueOf(this.serviceType) + ",scopes=" + String.valueOf(this.scopes) + ",qualifiers=" + String.valueOf(this.qualifiers) + ",contracts=" + String.valueOf(this.contracts) + ",contractType=" + String.valueOf(this.contractType) + ",runLevel=" + String.valueOf(this.runLevel) + ",weight=" + String.valueOf(this.weight) + ",includeAbstract=" + this.includeAbstract + ",dependency=" + String.valueOf(this.dependency) + ",factoryTypes=" + String.valueOf(this.factoryTypes) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Lookup)) {
                    return false;
                }
                Lookup other = (Lookup)o;
                return Objects.equals(this.serviceType, other.serviceType()) && Objects.equals(this.scopes, other.scopes()) && Objects.equals(this.qualifiers, other.qualifiers()) && Objects.equals(this.contracts, other.contracts()) && Objects.equals(this.contractType, other.contractType()) && Objects.equals(this.runLevel, other.runLevel()) && Objects.equals(this.weight, other.weight()) && this.includeAbstract == other.includeAbstract() && Objects.equals(this.dependency, other.dependency()) && Objects.equals(this.factoryTypes, other.factoryTypes());
            }

            public int hashCode() {
                return Objects.hash(this.serviceType, this.scopes, this.qualifiers, this.contracts, this.contractType, this.runLevel, this.weight, this.includeAbstract, this.dependency, this.factoryTypes);
            }
        }
    }
}

