/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.jaeger;

import io.helidon.common.configurable.Resource;
import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.TracerBuilder;
import io.helidon.tracing.opentelemetry.HelidonOpenTelemetry;
import io.helidon.tracing.opentelemetry.OpenTelemetryTracerProvider;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporter;
import io.opentelemetry.exporter.jaeger.JaegerGrpcSpanExporterBuilder;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

@Configured(prefix="tracing", root=true, description="Jaeger tracer configuration.")
public class JaegerTracerBuilder
implements TracerBuilder<JaegerTracerBuilder> {
    static final Logger LOGGER = Logger.getLogger(JaegerTracerBuilder.class.getName());
    static final boolean DEFAULT_ENABLED = true;
    static final String DEFAULT_HTTP_HOST = "localhost";
    static final int DEFAULT_HTTP_PORT = 14250;
    private final Map<String, String> tags = new HashMap<String, String>();
    private String serviceName;
    private String protocol = "http";
    private String host = "localhost";
    private int port = 14250;
    private SamplerType samplerType = SamplerType.CONSTANT;
    private Number samplerParam = 1;
    private boolean enabled = true;
    private boolean global = true;
    private Duration exporterTimeout = Duration.ofSeconds(10L);
    private byte[] privateKey;
    private byte[] certificate;
    private byte[] trustedCertificates;
    private String path;

    protected JaegerTracerBuilder() {
    }

    public static JaegerTracerBuilder forService(String serviceName) {
        return JaegerTracerBuilder.create().serviceName(serviceName);
    }

    public static JaegerTracerBuilder create(Config config) {
        return JaegerTracerBuilder.create().config(config);
    }

    static JaegerTracerBuilder create() {
        return new JaegerTracerBuilder();
    }

    public JaegerTracerBuilder serviceName(String name) {
        this.serviceName = name;
        return this;
    }

    public JaegerTracerBuilder collectorProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public JaegerTracerBuilder collectorPort(int port) {
        this.port = port;
        return this;
    }

    public JaegerTracerBuilder collectorPath(String path) {
        this.path = path;
        return this;
    }

    public JaegerTracerBuilder collectorHost(String host) {
        this.host = host;
        return this;
    }

    public JaegerTracerBuilder addTracerTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public JaegerTracerBuilder addTracerTag(String key, Number value) {
        this.tags.put(key, String.valueOf(value));
        return this;
    }

    public JaegerTracerBuilder addTracerTag(String key, boolean value) {
        this.tags.put(key, String.valueOf(value));
        return this;
    }

    public JaegerTracerBuilder config(Config config) {
        config.get("enabled").asBoolean().ifPresent(this::enabled);
        config.get("service").asString().ifPresent(this::serviceName);
        config.get("protocol").asString().ifPresent(this::collectorProtocol);
        config.get("host").asString().ifPresent(this::collectorHost);
        config.get("port").asInt().ifPresent(this::collectorPort);
        config.get("path").asString().ifPresent(this::collectorPath);
        config.get("sampler-type").asString().as(SamplerType::create).ifPresent(this::samplerType);
        config.get("sampler-param").asDouble().ifPresent(this::samplerParam);
        config.get("exporter-timeout-millis").asLong().ifPresent(it -> this.exporterTimeout(Duration.ofMillis(it)));
        config.get("private-key-pem").as(Resource::create).ifPresent(this::privateKey);
        config.get("client-cert-pem").as(Resource::create).ifPresent(this::clientCertificate);
        config.get("trusted-cert-pem").as(Resource::create).ifPresent(this::trustedCertificates);
        ((Map)config.get("tags").detach().asMap().orElseGet(Map::of)).forEach(this::addTracerTag);
        config.get("boolean-tags").asNodeList().ifPresent(nodes -> nodes.forEach(node -> this.addTracerTag(node.key().name(), (Boolean)node.asBoolean().get())));
        config.get("int-tags").asNodeList().ifPresent(nodes -> nodes.forEach(node -> this.addTracerTag(node.key().name(), (Number)node.asInt().get())));
        config.get("global").asBoolean().ifPresent(this::registerGlobal);
        return this;
    }

    public JaegerTracerBuilder privateKey(Resource resource) {
        this.privateKey = resource.bytes();
        return this;
    }

    public JaegerTracerBuilder clientCertificate(Resource resource) {
        this.certificate = resource.bytes();
        return this;
    }

    public JaegerTracerBuilder trustedCertificates(Resource resource) {
        this.trustedCertificates = resource.bytes();
        return this;
    }

    public JaegerTracerBuilder exporterTimeout(Duration exporterTimeout) {
        this.exporterTimeout = exporterTimeout;
        return this;
    }

    public JaegerTracerBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public JaegerTracerBuilder registerGlobal(boolean global) {
        this.global = global;
        return this;
    }

    public <B> B unwrap(Class<B> builderClass) {
        if (builderClass.isAssignableFrom(this.getClass())) {
            return builderClass.cast(this);
        }
        throw new IllegalArgumentException("This builder is a Jaeger tracer builder, cannot be unwrapped to " + builderClass.getName());
    }

    public JaegerTracerBuilder samplerParam(Number samplerParam) {
        this.samplerParam = samplerParam;
        return this;
    }

    public JaegerTracerBuilder samplerType(SamplerType samplerType) {
        this.samplerType = samplerType;
        return this;
    }

    public Tracer build() {
        Tracer result;
        if (this.enabled) {
            if (this.serviceName == null) {
                throw new IllegalArgumentException("Configuration must at least contain the 'service' key ('tracing.service` in MP) with service name");
            }
            JaegerGrpcSpanExporterBuilder spanExporterBuilder = JaegerGrpcSpanExporter.builder().setEndpoint(this.protocol + "://" + this.host + ":" + this.port + (this.path == null ? "" : this.path)).setTimeout(this.exporterTimeout);
            if (this.privateKey != null && this.certificate != null) {
                spanExporterBuilder.setClientTls(this.privateKey, this.certificate);
            }
            if (this.trustedCertificates != null) {
                spanExporterBuilder.setTrustedCertificates(this.trustedCertificates);
            }
            JaegerGrpcSpanExporter exporter = spanExporterBuilder.build();
            Sampler sampler = switch (this.samplerType) {
                default -> throw new IncompatibleClassChangeError();
                case SamplerType.RATIO -> Sampler.traceIdRatioBased((double)this.samplerParam.doubleValue());
                case SamplerType.CONSTANT -> this.samplerParam.intValue() == 1 ? Sampler.alwaysOn() : Sampler.alwaysOff();
            };
            io.opentelemetry.sdk.resources.Resource serviceName = io.opentelemetry.sdk.resources.Resource.create((Attributes)Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)this.serviceName));
            OpenTelemetrySdk ot = OpenTelemetrySdk.builder().setTracerProvider(SdkTracerProvider.builder().addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)exporter)).setSampler(sampler).setResource(serviceName).build()).setPropagators(ContextPropagators.create((TextMapPropagator)B3Propagator.injectingMultiHeaders())).build();
            result = HelidonOpenTelemetry.create((OpenTelemetry)ot, (io.opentelemetry.api.trace.Tracer)ot.getTracer(this.serviceName), this.tags);
            if (this.global) {
                GlobalOpenTelemetry.set((OpenTelemetry)ot);
            }
            LOGGER.info(() -> "Creating Jaeger tracer for '" + this.serviceName + "' configured with " + this.protocol + "://" + this.host + ":" + this.port);
        } else {
            LOGGER.info("Jaeger Tracer is explicitly disabled.");
            result = Tracer.noOp();
        }
        if (this.global) {
            OpenTelemetryTracerProvider.globalTracer((Tracer)result);
        }
        return result;
    }

    String path() {
        return this.path;
    }

    Map<String, String> tags() {
        return this.tags;
    }

    String serviceName() {
        return this.serviceName;
    }

    String protocol() {
        return this.protocol;
    }

    String host() {
        return this.host;
    }

    Integer port() {
        return this.port;
    }

    SamplerType samplerType() {
        return this.samplerType;
    }

    Number samplerParam() {
        return this.samplerParam;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    public static enum SamplerType {
        CONSTANT("const"),
        RATIO("ratio");

        private final String config;

        private SamplerType(String config) {
            this.config = config;
        }

        static SamplerType create(String value) {
            for (SamplerType sampler : SamplerType.values()) {
                if (!sampler.config().equals(value)) continue;
                return sampler;
            }
            throw new IllegalStateException("SamplerType " + value + " is not supported");
        }

        String config() {
            return this.config;
        }
    }
}

