/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.jaeger;

import io.helidon.common.context.Contexts;
import io.helidon.common.context.spi.DataPropagationProvider;
import io.helidon.tracing.Scope;
import io.helidon.tracing.Span;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.opentelemetry.OpenTelemetryTracerProvider;

public class JaegerDataPropagationProvider
implements DataPropagationProvider<JaegerContext> {
    private static final System.Logger LOGGER = System.getLogger(JaegerDataPropagationProvider.class.getName());

    public JaegerContext data() {
        return Contexts.context().map(context -> context.get(Span.class).map(span -> {
            Tracer tracer = context.get(Tracer.class).orElseGet(OpenTelemetryTracerProvider::globalTracer);
            return new JaegerContext(tracer, (Span)span);
        }).orElse(null)).orElse(null);
    }

    public void propagateData(JaegerContext context) {
        if (context != null) {
            context.scope = Span.current().map(Span::activate).orElse(null);
        }
    }

    public void clearData(JaegerContext context) {
        if (context != null && context.scope != null) {
            try {
                context.scope.close();
            }
            catch (Exception e) {
                LOGGER.log(System.Logger.Level.TRACE, "Cannot close tracing span", (Throwable)e);
            }
        }
    }

    static class JaegerContext {
        private final Span span;
        private final Tracer tracer;
        private Scope scope;

        JaegerContext(Tracer tracer, Span span) {
            this.tracer = tracer;
            this.span = span;
        }

        Scope scope() {
            return this.scope;
        }
    }
}

