/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.jaeger;

import io.helidon.common.Weight;
import io.helidon.tracing.Span;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.jaeger.JaegerTracerBuilder;
import io.helidon.tracing.opentelemetry.HelidonOpenTelemetry;
import io.helidon.tracing.opentelemetry.OpenTelemetryTracerProvider;
import io.helidon.tracing.spi.TracerProvider;
import io.opentelemetry.context.Context;
import java.util.Optional;

@Weight(value=100.0)
public class JaegerTracerProvider
implements TracerProvider {
    public Tracer global() {
        return OpenTelemetryTracerProvider.globalTracer();
    }

    public void global(Tracer tracer) {
        OpenTelemetryTracerProvider.globalTracer((Tracer)tracer);
    }

    public Optional<Span> currentSpan() {
        return Optional.ofNullable(io.opentelemetry.api.trace.Span.fromContextOrNull((Context)Context.current())).map(HelidonOpenTelemetry::create);
    }

    public JaegerTracerBuilder createBuilder() {
        return JaegerTracerBuilder.create();
    }

    public boolean available() {
        return true;
    }
}

