/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.jersey.client;

import io.helidon.tracing.Scope;
import io.helidon.tracing.Span;
import io.helidon.tracing.jersey.client.ClientTracingFilter;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import org.glassfish.jersey.client.spi.PostInvocationInterceptor;

public class ClientTracingInterceptor
implements PostInvocationInterceptor {
    public void afterRequest(ClientRequestContext requestContext, ClientResponseContext responseContext) {
    }

    public void onException(ClientRequestContext requestContext, PostInvocationInterceptor.ExceptionContext exceptionContext) {
        Object spanProperty = requestContext.getProperty(ClientTracingFilter.SPAN_PROPERTY_NAME);
        Object scopeProperty = requestContext.getProperty(ClientTracingFilter.SPAN_SCOPE_PROPERTY_NAME);
        if (spanProperty instanceof Span) {
            Span span = (Span)spanProperty;
            span.status(Span.Status.ERROR);
            span.end((Throwable)exceptionContext.getThrowables().peek());
            requestContext.removeProperty(ClientTracingFilter.SPAN_PROPERTY_NAME);
        }
        if (scopeProperty instanceof Scope) {
            Scope scope = (Scope)scopeProperty;
            scope.close();
            requestContext.removeProperty(ClientTracingFilter.SPAN_SCOPE_PROPERTY_NAME);
        }
        for (Throwable throwable : exceptionContext.getThrowables()) {
            throwable.printStackTrace();
        }
    }
}

