/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.jersey;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.tracing.Scope;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tag;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.config.SpanTracingConfig;
import io.helidon.tracing.config.TracingConfigUtil;
import io.helidon.tracing.jersey.client.ClientTracingFilter;
import io.helidon.tracing.jersey.client.internal.TracingContext;
import io.helidon.webserver.ServerRequest;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

@ConstrainedTo(value=RuntimeType.SERVER)
@PreMatching
public abstract class AbstractTracingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String SPAN_PROPERTY = AbstractTracingFilter.class.getName() + ".span";
    private static final String SPAN_SCOPE_PROPERTY = AbstractTracingFilter.class.getName() + ".spanScope";
    private static final String SPAN_FINISHED_PROPERTY = AbstractTracingFilter.class.getName() + ".spanFinished";
    private static final Logger LOGGER = Logger.getLogger(AbstractTracingFilter.class.getName());
    private static final AtomicBoolean DOUBLE_FINISH_LOGGED = new AtomicBoolean();

    public void filter(ContainerRequestContext requestContext) {
        if (!this.tracingEnabled(requestContext)) {
            return;
        }
        Context context = (Context)Contexts.context().orElseThrow(() -> new IllegalStateException("Context must be available in Jersey"));
        String spanName = this.spanName(requestContext);
        SpanTracingConfig spanConfig = TracingConfigUtil.spanConfig((String)"jax-rs", (String)spanName, (Context)context);
        if (spanConfig.enabled()) {
            spanName = spanConfig.newName().orElse(spanName);
            Tracer tracer = context.get(Tracer.class).orElseGet(Tracer::global);
            SpanContext parentSpan = context.get(ServerRequest.class, SpanContext.class).orElseGet(() -> context.get(SpanContext.class).orElse(null));
            Span.Builder spanBuilder = tracer.spanBuilder(spanName).kind(Span.Kind.SERVER).tag(Tag.HTTP_METHOD.create((Object)requestContext.getMethod())).tag(Tag.HTTP_URL.create((Object)this.url(requestContext))).tag(Tag.COMPONENT.create((Object)"jaxrs"));
            if (null != parentSpan) {
                spanBuilder.parent(parentSpan);
            }
            this.configureSpan(spanBuilder);
            Span span = spanBuilder.start();
            Scope spanScope = span.activate();
            context.register((Object)span);
            context.register((Object)spanScope);
            context.register(ClientTracingFilter.class, (Object)span.context());
            requestContext.setProperty(SPAN_PROPERTY, (Object)span);
            requestContext.setProperty(SPAN_SCOPE_PROPERTY, (Object)spanScope);
            if (context.get(TracingContext.class).isEmpty()) {
                context.register((Object)TracingContext.create((Tracer)tracer, (Map)requestContext.getHeaders()));
            }
            context.get(TracingContext.class).ifPresent(tctx -> tctx.parentSpan(span.context()));
            if (null == parentSpan) {
                context.register((Object)span.context());
            }
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Span span = (Span)requestContext.getProperty(SPAN_PROPERTY);
        if (null == span) {
            return;
        }
        if (requestContext.getProperty(SPAN_FINISHED_PROPERTY) != null) {
            if (DOUBLE_FINISH_LOGGED.compareAndSet(false, true)) {
                LOGGER.warning("Response filter called twice. Most likely a response with streaming output was returned, where response had 200 status code, but streaming failed with another error. Status: " + responseContext.getStatusInfo());
            }
            return;
        }
        switch (responseContext.getStatusInfo().getFamily()) {
            case INFORMATIONAL: 
            case SUCCESSFUL: 
            case REDIRECTION: 
            case OTHER: {
                break;
            }
            case CLIENT_ERROR: 
            case SERVER_ERROR: {
                span.status(Span.Status.ERROR);
                span.addEvent("error", Map.of());
                break;
            }
        }
        Tag.HTTP_STATUS.create((Object)responseContext.getStatus()).apply(span);
        requestContext.setProperty(SPAN_FINISHED_PROPERTY, (Object)true);
        span.end();
        Scope scope = (Scope)requestContext.getProperty(SPAN_SCOPE_PROPERTY);
        if (scope != null) {
            try {
                scope.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected String url(ContainerRequestContext requestContext) {
        String hostHeader = requestContext.getHeaderString("host");
        URI requestUri = requestContext.getUriInfo().getRequestUri();
        if (null != hostHeader) {
            return requestUri.getScheme() + "://" + hostHeader + requestUri.getPath();
        }
        return requestUri.toString();
    }

    protected abstract boolean tracingEnabled(ContainerRequestContext var1);

    protected abstract String spanName(ContainerRequestContext var1);

    protected abstract void configureSpan(Span.Builder var1);
}

