/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.opentelemetry;

import io.helidon.tracing.Scope;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.opentelemetry.OpenTelemetryScope;
import io.helidon.tracing.opentelemetry.OpenTelemetrySpanContext;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.util.Map;

class OpenTelemetrySpan
implements Span {
    private final io.opentelemetry.api.trace.Span delegate;

    OpenTelemetrySpan(io.opentelemetry.api.trace.Span span) {
        this.delegate = span;
    }

    public void tag(String key, String value) {
        this.delegate.setAttribute(key, value);
    }

    public void tag(String key, Boolean value) {
        this.delegate.setAttribute(key, value.booleanValue());
    }

    public void tag(String key, Number value) {
        if (value instanceof Double || value instanceof Float) {
            this.delegate.setAttribute(key, value.doubleValue());
        } else {
            this.delegate.setAttribute(key, value.longValue());
        }
    }

    public void status(Span.Status status) {
        switch (status) {
            case OK: {
                this.delegate.setStatus(StatusCode.OK);
                break;
            }
            case ERROR: {
                this.delegate.setStatus(StatusCode.ERROR);
                break;
            }
        }
    }

    public SpanContext context() {
        return new OpenTelemetrySpanContext(Context.current().with((ImplicitContextKeyed)this.delegate));
    }

    public void addEvent(String name, Map<String, ?> attributes) {
        this.delegate.addEvent(name, this.toAttributes(attributes));
    }

    public void end() {
        this.delegate.end();
    }

    public void end(Throwable t) {
        this.delegate.recordException(t);
        this.delegate.setStatus(StatusCode.ERROR);
        this.delegate.end();
    }

    public Scope activate() {
        return new OpenTelemetryScope(this.delegate.makeCurrent());
    }

    private Attributes toAttributes(Map<String, ?> attributes) {
        AttributesBuilder builder = Attributes.builder();
        attributes.forEach((key, value) -> {
            if (value instanceof Long) {
                Long l = (Long)value;
                builder.put(key, l.longValue());
            } else if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                builder.put(key, b.booleanValue());
            } else if (value instanceof Double) {
                Double d = (Double)value;
                builder.put(key, d.doubleValue());
            } else {
                builder.put(key, String.valueOf(value));
            }
        });
        return builder.build();
    }
}

