/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.opentelemetry;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.baggage.BaggageEntryMetadata;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;

class MutableOpenTelemetryBaggage
implements Baggage {
    private final Map<String, BaggageEntry> values = new LinkedHashMap<String, BaggageEntry>();
    private final Map<String, BaggageEntry> valuesView = Collections.unmodifiableMap(this.values);

    MutableOpenTelemetryBaggage() {
    }

    private MutableOpenTelemetryBaggage(Builder builder) {
        this.values.putAll(builder.values);
    }

    public int size() {
        return this.values.size();
    }

    public void forEach(BiConsumer<? super String, ? super BaggageEntry> consumer) {
        this.values.forEach(consumer);
    }

    public Map<String, BaggageEntry> asMap() {
        return this.valuesView;
    }

    public String getEntryValue(String entryKey) {
        BaggageEntry entry = this.values.get(entryKey);
        return entry != null ? entry.getValue() : null;
    }

    public BaggageBuilder toBuilder() {
        return new Builder(this.values);
    }

    void baggage(String key, String value) {
        this.values.put(key, new HBaggageEntry(value, new HBaggageEntryMetadata("")));
    }

    static class Builder
    implements BaggageBuilder {
        private final Map<String, BaggageEntry> values = new HashMap<String, BaggageEntry>();

        private Builder(Map<String, BaggageEntry> values) {
            this.values.putAll(values);
        }

        public BaggageBuilder put(String key, String value, BaggageEntryMetadata entryMetadata) {
            this.values.put(key, new HBaggageEntry(value, entryMetadata));
            return this;
        }

        public BaggageBuilder remove(String key) {
            this.values.remove(key);
            return this;
        }

        public Baggage build() {
            return new MutableOpenTelemetryBaggage(this);
        }
    }

    record HBaggageEntry(String value, BaggageEntryMetadata metadata) implements BaggageEntry
    {
        public String getValue() {
            return this.value;
        }

        public BaggageEntryMetadata getMetadata() {
            return this.metadata;
        }
    }

    record HBaggageEntryMetadata(String metadata) implements BaggageEntryMetadata
    {
        public String getValue() {
            return this.metadata;
        }
    }
}

