/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.opentelemetry;

import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.opentelemetry.OpenTelemetrySpan;
import io.helidon.tracing.opentelemetry.OpenTelemetrySpanContext;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import java.time.Instant;

class OpenTelemetrySpanBuilder
implements Span.Builder<OpenTelemetrySpanBuilder> {
    private final SpanBuilder spanBuilder;
    private boolean parentSet;
    private Baggage parentBaggage;

    OpenTelemetrySpanBuilder(SpanBuilder spanBuilder) {
        this.spanBuilder = spanBuilder;
    }

    public Span build() {
        return this.start();
    }

    public OpenTelemetrySpanBuilder parent(SpanContext spanContext) {
        this.parentSet = true;
        spanContext.asParent((Span.Builder)this);
        if (spanContext instanceof OpenTelemetrySpanContext) {
            OpenTelemetrySpanContext otsc = (OpenTelemetrySpanContext)spanContext;
            this.parentBaggage = Baggage.fromContext((Context)otsc.openTelemetry());
        }
        return this;
    }

    public OpenTelemetrySpanBuilder kind(Span.Kind kind) {
        switch (kind) {
            case SERVER: {
                this.spanBuilder.setSpanKind(SpanKind.SERVER);
                break;
            }
            case CLIENT: {
                this.spanBuilder.setSpanKind(SpanKind.CLIENT);
                break;
            }
            case PRODUCER: {
                this.spanBuilder.setSpanKind(SpanKind.PRODUCER);
                break;
            }
            case CONSUMER: {
                this.spanBuilder.setSpanKind(SpanKind.CONSUMER);
                break;
            }
            default: {
                this.spanBuilder.setSpanKind(SpanKind.INTERNAL);
            }
        }
        return this;
    }

    public OpenTelemetrySpanBuilder tag(String key, String value) {
        this.spanBuilder.setAttribute(key, value);
        return this;
    }

    public OpenTelemetrySpanBuilder tag(String key, Boolean value) {
        this.spanBuilder.setAttribute(key, value.booleanValue());
        return this;
    }

    public OpenTelemetrySpanBuilder tag(String key, Number value) {
        if (value instanceof Double || value instanceof Float) {
            this.spanBuilder.setAttribute(key, value.doubleValue());
        } else {
            this.spanBuilder.setAttribute(key, value.longValue());
        }
        return this;
    }

    public Span start(Instant instant) {
        if (!this.parentSet) {
            this.spanBuilder.setNoParent();
        }
        this.spanBuilder.setStartTimestamp(instant);
        io.opentelemetry.api.trace.Span span = this.spanBuilder.startSpan();
        OpenTelemetrySpan result = new OpenTelemetrySpan(span);
        if (this.parentBaggage != null) {
            this.parentBaggage.forEach((key, baggageEntry) -> result.baggage((String)key, baggageEntry.getValue()));
        }
        return result;
    }

    void parent(Context context) {
        this.parentSet = true;
        this.spanBuilder.setParent(context);
    }
}

