/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.opentelemetry;

import io.helidon.common.LazyValue;
import io.helidon.common.context.Contexts;
import io.helidon.tracing.Span;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.TracerBuilder;
import io.helidon.tracing.opentelemetry.HelidonOpenTelemetry;
import io.helidon.tracing.opentelemetry.OpenTelemetryTracer;
import io.helidon.tracing.spi.TracerProvider;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.context.Context;
import jakarta.annotation.Priority;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@Priority(value=6000)
public class OpenTelemetryTracerProvider
implements TracerProvider {
    private static final System.Logger LOGGER = System.getLogger(OpenTelemetryTracerProvider.class.getName());
    private static final AtomicReference<Tracer> CONFIGURED_TRACER = new AtomicReference();
    private static final AtomicBoolean GLOBAL_SET = new AtomicBoolean();
    private static final LazyValue<Tracer> GLOBAL_TRACER = LazyValue.create(() -> {
        Tracer tracer = CONFIGURED_TRACER.get();
        if (tracer != null) {
            return tracer;
        }
        io.helidon.common.context.Context global = Contexts.globalContext();
        return global.get(OpenTelemetryTracer.class).map(Tracer.class::cast).orElseGet(() -> {
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "Global tracer is not registered. Register it through Tracer.global(HelidonOpenTelemetry.create(ot, tracer). Using global open telemetry");
            }
            OpenTelemetry ot = GlobalOpenTelemetry.get();
            return new OpenTelemetryTracer(ot, ot.getTracer("helidon-service"), Map.of());
        });
    });

    public static void globalTracer(Tracer tracer) {
        GLOBAL_SET.set(true);
        CONFIGURED_TRACER.set(tracer);
    }

    public static Tracer globalTracer() {
        return (Tracer)GLOBAL_TRACER.get();
    }

    public static Optional<Span> activeSpan() {
        Context otelContext = Context.current();
        io.opentelemetry.api.trace.Span otelSpan = io.opentelemetry.api.trace.Span.fromContextOrNull((Context)otelContext);
        if (otelSpan == null) {
            return Optional.empty();
        }
        Baggage otelBaggage = Baggage.current();
        return Optional.of(HelidonOpenTelemetry.create(otelSpan, otelBaggage));
    }

    public TracerBuilder<?> createBuilder() {
        return OpenTelemetryTracer.builder();
    }

    public Tracer global() {
        return OpenTelemetryTracerProvider.globalTracer();
    }

    public void global(Tracer tracer) {
        if (tracer instanceof OpenTelemetryTracer) {
            OpenTelemetryTracer ott = (OpenTelemetryTracer)tracer;
            OpenTelemetryTracerProvider.globalTracer(ott);
        }
        throw new IllegalArgumentException("Tracer must be an instance of Helidon OpenTelemetry tracer. Please use HelidonOpenTelemetry to create such instance");
    }

    public Optional<Span> currentSpan() {
        return OpenTelemetryTracerProvider.activeSpan();
    }

    public boolean available() {
        return GLOBAL_SET.get();
    }
}

