/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.opentelemetry;

import io.helidon.config.Config;
import io.helidon.tracing.Span;
import io.helidon.tracing.opentelemetry.OpenTelemetrySpan;
import io.helidon.tracing.opentelemetry.OpenTelemetryTracer;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import java.util.Map;
import java.util.Optional;

public final class HelidonOpenTelemetry {
    private static final System.Logger LOGGER = System.getLogger(HelidonOpenTelemetry.class.getName());
    static final String OTEL_AGENT_PRESENT_PROPERTY = "otel.agent.present";
    static final String IO_OPENTELEMETRY_JAVAAGENT = "io.opentelemetry.javaagent";

    private HelidonOpenTelemetry() {
    }

    public static OpenTelemetryTracer create(OpenTelemetry telemetry, Tracer tracer, Map<String, String> tags) {
        return new OpenTelemetryTracer(telemetry, tracer, tags);
    }

    public static Span create(io.opentelemetry.api.trace.Span span) {
        return new OpenTelemetrySpan(span);
    }

    public static final class AgentDetector {
        private AgentDetector() {
        }

        public static boolean isAgentPresent(Config config) {
            Optional agentPresent;
            if (config != null && (agentPresent = config.get(HelidonOpenTelemetry.OTEL_AGENT_PRESENT_PROPERTY).asBoolean().asOptional()).isPresent()) {
                return (Boolean)agentPresent.get();
            }
            if (AgentDetector.checkContext() || AgentDetector.checkSystemProperties()) {
                if (LOGGER.isLoggable(System.Logger.Level.INFO)) {
                    LOGGER.log(System.Logger.Level.INFO, "OpenTelemetry Agent detected");
                }
                return true;
            }
            return false;
        }

        private static boolean checkSystemProperties() {
            return System.getProperties().stringPropertyNames().stream().anyMatch(property -> property.contains(HelidonOpenTelemetry.IO_OPENTELEMETRY_JAVAAGENT));
        }

        private static boolean checkContext() {
            return Context.current().getClass().getName().contains("agent");
        }
    }
}

