/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.opentelemetry;

import io.helidon.config.Config;
import io.helidon.tracing.HeaderConsumer;
import io.helidon.tracing.HeaderProvider;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.TracerBuilder;
import io.helidon.tracing.opentelemetry.OpenTelemetrySpanBuilder;
import io.helidon.tracing.opentelemetry.OpenTelemetrySpanContext;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.Map;
import java.util.Optional;

class OpenTelemetryTracer
implements Tracer {
    private static final TextMapGetter GETTER = new Getter();
    private static final TextMapSetter SETTER = new Setter();
    private final OpenTelemetry telemetry;
    private final io.opentelemetry.api.trace.Tracer delegate;
    private final boolean enabled;
    private final TextMapPropagator propagator;
    private final Map<String, String> tags;

    OpenTelemetryTracer(OpenTelemetry telemetry, io.opentelemetry.api.trace.Tracer tracer, Map<String, String> tags) {
        this.telemetry = telemetry;
        this.delegate = tracer;
        this.enabled = !tracer.getClass().getSimpleName().equals("DefaultTracer");
        this.propagator = telemetry.getPropagators().getTextMapPropagator();
        this.tags = tags;
    }

    static Builder builder() {
        return new Builder();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Span.Builder<?> spanBuilder(String name) {
        OpenTelemetrySpanBuilder builder = new OpenTelemetrySpanBuilder(this.delegate.spanBuilder(name));
        this.tags.forEach(builder::tag);
        return builder;
    }

    public Optional<SpanContext> extract(HeaderProvider headersProvider) {
        Context context = this.propagator.extract(Context.current(), (Object)headersProvider, GETTER);
        return Optional.ofNullable(context).map(OpenTelemetrySpanContext::new);
    }

    public void inject(SpanContext spanContext, HeaderProvider inboundHeadersProvider, HeaderConsumer outboundHeadersConsumer) {
        this.propagator.inject(((OpenTelemetrySpanContext)spanContext).openTelemetry(), (Object)outboundHeadersConsumer, SETTER);
    }

    public <T> T unwrap(Class<T> tracerClass) {
        if (tracerClass.isAssignableFrom(this.delegate.getClass())) {
            return tracerClass.cast(this.delegate);
        }
        throw new IllegalArgumentException("Cannot provide an instance of " + tracerClass.getName() + ", telemetry tracer is: " + this.delegate.getClass().getName());
    }

    static class Builder
    implements TracerBuilder<Builder> {
        private OpenTelemetry ot;
        private String serviceName = "helidon-service";
        private boolean registerGlobal;

        Builder() {
        }

        public Tracer build() {
            if (this.ot == null) {
                this.ot = GlobalOpenTelemetry.get();
            }
            io.opentelemetry.api.trace.Tracer tracer = this.ot.getTracer(this.serviceName);
            OpenTelemetryTracer result = new OpenTelemetryTracer(this.ot, tracer, Map.of());
            if (this.registerGlobal) {
                Tracer.global((Tracer)result);
            }
            return result;
        }

        Builder openTelemetry(OpenTelemetry ot) {
            this.ot = ot;
            return this;
        }

        public Builder serviceName(String name) {
            this.serviceName = name;
            return this;
        }

        public Builder collectorProtocol(String protocol) {
            return this;
        }

        public Builder collectorPort(int port) {
            return this;
        }

        public Builder collectorHost(String host) {
            return this;
        }

        public Builder collectorPath(String path) {
            return this;
        }

        public Builder addTracerTag(String key, String value) {
            return this;
        }

        public Builder addTracerTag(String key, Number value) {
            return this;
        }

        public Builder addTracerTag(String key, boolean value) {
            return this;
        }

        public Builder config(Config config) {
            return this;
        }

        public Builder enabled(boolean enabled) {
            return this;
        }

        public Builder registerGlobal(boolean global) {
            this.registerGlobal = global;
            return this;
        }

        public <B> B unwrap(Class<B> builderClass) {
            if (builderClass.isAssignableFrom(this.getClass())) {
                return builderClass.cast(this);
            }
            throw new IllegalArgumentException("Cannot unwrap " + builderClass + " from Opentelmetry tracer builder.");
        }
    }

    private static class Getter
    implements TextMapGetter<HeaderProvider> {
        private Getter() {
        }

        public Iterable<String> keys(HeaderProvider headerProvider) {
            return headerProvider.keys();
        }

        public String get(HeaderProvider headerProvider, String s) {
            return headerProvider.get(s).orElse(null);
        }
    }

    private static class Setter
    implements TextMapSetter<HeaderConsumer> {
        private Setter() {
        }

        public void set(HeaderConsumer carrier, String key, String value) {
            carrier.set(key, new String[]{value});
        }
    }
}

