/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.opentracing;

import io.helidon.config.Config;
import io.helidon.tracing.opentracing.OpenTracingTracerBuilder;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import java.net.URI;

final class NoOpBuilder
implements OpenTracingTracerBuilder<NoOpBuilder> {
    private NoOpBuilder() {
    }

    static OpenTracingTracerBuilder<?> create() {
        return new NoOpBuilder();
    }

    @Override
    public NoOpBuilder serviceName(String name) {
        return this;
    }

    @Override
    public NoOpBuilder collectorUri(URI uri) {
        return this;
    }

    @Override
    public NoOpBuilder collectorProtocol(String protocol) {
        return this;
    }

    @Override
    public NoOpBuilder collectorPort(int port) {
        return this;
    }

    @Override
    public NoOpBuilder collectorHost(String host) {
        return this;
    }

    @Override
    public NoOpBuilder collectorPath(String path) {
        return this;
    }

    @Override
    public NoOpBuilder addTracerTag(String key, String value) {
        return this;
    }

    @Override
    public NoOpBuilder addTracerTag(String key, Number value) {
        return this;
    }

    @Override
    public NoOpBuilder addTracerTag(String key, boolean value) {
        return this;
    }

    @Override
    public NoOpBuilder config(Config config) {
        return this;
    }

    @Override
    public NoOpBuilder enabled(boolean enabled) {
        return this;
    }

    @Override
    public NoOpBuilder registerGlobal(boolean global) {
        return this;
    }

    @Override
    public Tracer build() {
        return NoopTracerFactory.create();
    }

    @Override
    public boolean enabled() {
        return false;
    }

    @Override
    public <B> B unwrap(Class<B> builderClass) {
        if (NoOpBuilder.class == builderClass) {
            return builderClass.cast(this);
        }
        throw new IllegalArgumentException("This is " + NoOpBuilder.class.getName() + ", not " + builderClass.getName());
    }
}

