/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.opentracing;

import io.helidon.config.Config;
import io.helidon.tracing.HeaderConsumer;
import io.helidon.tracing.HeaderProvider;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.TracerBuilder;
import io.helidon.tracing.opentracing.OpenTracingContext;
import io.helidon.tracing.opentracing.OpenTracingProviderHelper;
import io.helidon.tracing.opentracing.OpenTracingSpanBuilder;
import io.helidon.tracing.opentracing.OpenTracingTracerBuilder;
import io.opentracing.noop.NoopScopeManager;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.propagation.TextMapAdapter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

class OpenTracingTracer
implements Tracer {
    private final io.opentracing.Tracer delegate;
    private final boolean enabled;

    private OpenTracingTracer(io.opentracing.Tracer delegate, boolean enabled) {
        this.delegate = delegate;
        this.enabled = enabled;
    }

    static Tracer create(io.opentracing.Tracer tracer) {
        return new OpenTracingTracer(tracer, !(tracer.scopeManager() instanceof NoopScopeManager));
    }

    static Builder builder() {
        return new Builder();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Span.Builder<?> spanBuilder(String name) {
        return new OpenTracingSpanBuilder(this.delegate, this.delegate.buildSpan(name));
    }

    public Optional<SpanContext> extract(HeaderProvider headersProvider) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String key : headersProvider.keys()) {
            headers.put(key, headersProvider.get(key).orElse(null));
        }
        io.opentracing.SpanContext context = this.delegate.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapAdapter(headers));
        if (context == null) {
            return Optional.empty();
        }
        return Optional.of(new OpenTracingContext(context));
    }

    public void inject(SpanContext spanContext, HeaderProvider inboundHeadersProvider, final HeaderConsumer outboundHeadersConsumer) {
        if (spanContext instanceof OpenTracingContext) {
            OpenTracingContext otc = (OpenTracingContext)spanContext;
            this.delegate.inject(otc.openTracing(), Format.Builtin.HTTP_HEADERS, (Object)new TextMap(){

                public Iterator<Map.Entry<String, String>> iterator() {
                    throw new UnsupportedOperationException("TextMapInjectAdapter should only be used with Tracer.inject()");
                }

                public void put(String key, String value) {
                    outboundHeadersConsumer.set(key, new String[]{value});
                }
            });
            OpenTracingProviderHelper.provider().updateOutboundHeaders(this.delegate, otc.openTracing(), inboundHeadersProvider, outboundHeadersConsumer);
        }
    }

    public <T> T unwrap(Class<T> tracerClass) {
        if (tracerClass.isAssignableFrom(this.delegate.getClass())) {
            return tracerClass.cast(this.delegate);
        }
        throw new IllegalArgumentException("Cannot provide an instance of " + tracerClass.getName() + ", open tracing tracer is: " + this.delegate.getClass().getName());
    }

    io.opentracing.Tracer openTracing() {
        return this.delegate;
    }

    public static class Builder
    implements TracerBuilder<Builder> {
        private final OpenTracingTracerBuilder<?> delegate = OpenTracingProviderHelper.findTracerBuilder();

        private Builder() {
        }

        public Tracer build() {
            return new OpenTracingTracer(this.delegate.build(), this.delegate.enabled());
        }

        public Builder serviceName(String name) {
            this.delegate.serviceName(name);
            return this;
        }

        public Builder collectorProtocol(String protocol) {
            this.delegate.collectorProtocol(protocol);
            return this;
        }

        public Builder collectorPort(int port) {
            this.delegate.collectorPort(port);
            return this;
        }

        public Builder collectorHost(String host) {
            this.delegate.collectorHost(host);
            return this;
        }

        public Builder collectorPath(String path) {
            this.delegate.collectorPath(path);
            return this;
        }

        public Builder addTracerTag(String key, String value) {
            this.delegate.addTracerTag(key, value);
            return this;
        }

        public Builder addTracerTag(String key, Number value) {
            this.delegate.addTracerTag(key, value);
            return this;
        }

        public Builder addTracerTag(String key, boolean value) {
            this.delegate.addTracerTag(key, value);
            return this;
        }

        public Builder config(Config config) {
            this.delegate.config(config);
            return this;
        }

        public Builder enabled(boolean enabled) {
            this.delegate.enabled(enabled);
            return this;
        }

        public Builder registerGlobal(boolean global) {
            this.delegate.registerGlobal(global);
            return this;
        }

        public <T> T unwrap(Class<T> builderClass) {
            if (OpenTracingTracer.class == builderClass) {
                return builderClass.cast(this);
            }
            return this.delegate.unwrap(builderClass);
        }
    }
}

