/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.opentracing;

import io.helidon.common.Builder;
import io.helidon.config.Config;
import io.helidon.config.metadata.Configured;
import io.helidon.tracing.opentracing.OpenTracingProviderHelper;
import io.opentracing.Tracer;
import java.net.URI;
import java.util.Objects;

@Configured(description="OpenTracing tracer configuration.", ignoreBuildMethod=true)
public interface OpenTracingTracerBuilder<T extends OpenTracingTracerBuilder<T>>
extends Builder<T, Tracer> {
    public static OpenTracingTracerBuilder<?> create(String serviceName) {
        return OpenTracingProviderHelper.findTracerBuilder().serviceName(serviceName);
    }

    public static OpenTracingTracerBuilder<?> create(Config config) {
        return OpenTracingProviderHelper.findTracerBuilder().config(config);
    }

    public T serviceName(String var1);

    default public T collectorUri(URI uri) {
        Objects.requireNonNull(uri);
        OpenTracingTracerBuilder<T> result = (OpenTracingTracerBuilder)this.identity();
        if (null != uri.getScheme()) {
            result = result.collectorProtocol(uri.getScheme());
        }
        if (null != uri.getHost()) {
            result = result.collectorHost(uri.getHost());
        }
        if (null != uri.getPath()) {
            result = result.collectorPath(uri.getPath());
        }
        if (uri.getPort() >= -1) {
            result = result.collectorPort(uri.getPort());
        }
        return (T)result;
    }

    public T collectorProtocol(String var1);

    public T collectorPort(int var1);

    public T collectorHost(String var1);

    public T collectorPath(String var1);

    public T addTracerTag(String var1, String var2);

    public T addTracerTag(String var1, Number var2);

    public T addTracerTag(String var1, boolean var2);

    public T config(Config var1);

    public T enabled(boolean var1);

    public T registerGlobal(boolean var1);

    public Tracer build();

    public boolean enabled();

    public <B> B unwrap(Class<B> var1);
}

