/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.opentracing;

import io.helidon.tracing.Scope;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.opentracing.OpenTracingContext;
import io.helidon.tracing.opentracing.OpenTracingScope;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Map;

class OpenTracingSpan
implements Span {
    private final Tracer tracer;
    private final io.opentracing.Span delegate;
    private final OpenTracingContext context;

    OpenTracingSpan(Tracer tracer, io.opentracing.Span delegate) {
        this.tracer = tracer;
        this.delegate = delegate;
        this.context = new OpenTracingContext(delegate.context());
    }

    public void tag(String key, String value) {
        this.delegate.setTag(key, value);
    }

    public void tag(String key, Boolean value) {
        this.delegate.setTag(key, value.booleanValue());
    }

    public void tag(String key, Number value) {
        this.delegate.setTag(key, value);
    }

    public void status(Span.Status status) {
        if (status == Span.Status.ERROR) {
            Tags.ERROR.set(this.delegate, Boolean.valueOf(true));
        }
    }

    public SpanContext context() {
        return this.context;
    }

    public void addEvent(String name, Map<String, ?> attributes) {
        HashMap newMap = new HashMap(attributes);
        newMap.put("event", name);
        this.delegate.log(newMap);
    }

    public void end() {
        this.delegate.finish();
    }

    public void end(Throwable throwable) {
        this.status(Span.Status.ERROR);
        this.delegate.log(Map.of("event", "error", "error.kind", "Exception", "error.object", throwable, "message", throwable.getMessage()));
        this.delegate.finish();
    }

    public Scope activate() {
        return new OpenTracingScope(this.tracer.activateSpan(this.delegate));
    }

    public <T> T unwrap(Class<T> spanClass) {
        if (spanClass.isAssignableFrom(this.delegate.getClass())) {
            return spanClass.cast(this.delegate);
        }
        throw new IllegalArgumentException("Cannot provide an instance of " + spanClass.getName() + ", open tracing span is: " + this.delegate.getClass().getName());
    }
}

