/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.opentracing;

import io.helidon.common.Weight;
import io.helidon.tracing.Span;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.TracerBuilder;
import io.helidon.tracing.opentracing.OpenTracingProviderHelper;
import io.helidon.tracing.opentracing.OpenTracingSpan;
import io.helidon.tracing.opentracing.OpenTracingTracer;
import io.helidon.tracing.spi.TracerProvider;
import io.opentracing.noop.NoopSpan;
import io.opentracing.util.GlobalTracer;
import java.util.Optional;

@Weight(value=50.0)
public class OpenTracingTracerProvider
implements TracerProvider {
    public TracerBuilder<?> createBuilder() {
        return OpenTracingTracer.builder();
    }

    public Tracer global() {
        return OpenTracingTracer.create(GlobalTracer.get());
    }

    public void global(Tracer tracer) {
        if (tracer instanceof OpenTracingTracer) {
            OpenTracingTracer opt = (OpenTracingTracer)tracer;
            GlobalTracer.registerIfAbsent((io.opentracing.Tracer)opt.openTracing());
        }
    }

    public Optional<Span> currentSpan() {
        io.opentracing.Tracer tracer = GlobalTracer.get();
        return Optional.ofNullable(tracer.activeSpan()).flatMap(it -> it instanceof NoopSpan ? Optional.empty() : Optional.of(it)).map(it -> new OpenTracingSpan(tracer, (io.opentracing.Span)it));
    }

    public boolean available() {
        return OpenTracingProviderHelper.available();
    }
}

