/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.tracerresolver;

import io.helidon.config.Config;
import io.helidon.tracing.opentracing.OpenTracingTracerBuilder;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.util.GlobalTracer;
import java.util.logging.Logger;

class TracerResolverBuilder
implements OpenTracingTracerBuilder<TracerResolverBuilder> {
    private static final Logger LOGGER = Logger.getLogger(TracerResolverBuilder.class.getName());
    private String helidonServiceName;
    private boolean enabled = true;
    private boolean registerGlobal;

    TracerResolverBuilder() {
    }

    public TracerResolverBuilder serviceName(String name) {
        this.helidonServiceName = name;
        return this;
    }

    public TracerResolverBuilder collectorProtocol(String protocol) {
        return this;
    }

    public TracerResolverBuilder collectorPort(int port) {
        return this;
    }

    public TracerResolverBuilder collectorHost(String host) {
        return this;
    }

    public TracerResolverBuilder collectorPath(String path) {
        return this;
    }

    public TracerResolverBuilder addTracerTag(String key, String value) {
        return this;
    }

    public TracerResolverBuilder addTracerTag(String key, Number value) {
        return this;
    }

    public TracerResolverBuilder addTracerTag(String key, boolean value) {
        return this;
    }

    public TracerResolverBuilder config(Config config) {
        config.get("enabled").asBoolean().ifPresent(this::enabled);
        config.get("service").asString().ifPresent(this::serviceName);
        config.get("global").asBoolean().ifPresent(this::registerGlobal);
        return this;
    }

    public TracerResolverBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public TracerResolverBuilder registerGlobal(boolean global) {
        this.registerGlobal = global;
        return this;
    }

    public Tracer build() {
        Tracer tracer;
        if (this.enabled) {
            tracer = TracerResolver.resolveTracer();
            if (null == tracer) {
                tracer = NoopTracerFactory.create();
                LOGGER.info("TracerResolver not configured, tracing is disabled");
            } else {
                LOGGER.info("Using resolved tracer (all Helidon specific configuration options ignored): " + tracer);
            }
        } else {
            LOGGER.info("TracerResolver tracer is explicitly disabled for " + this.helidonServiceName + ".");
            tracer = NoopTracerFactory.create();
        }
        if (this.registerGlobal) {
            GlobalTracer.registerIfAbsent((Tracer)tracer);
        }
        return tracer;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public <B> B unwrap(Class<B> builderClass) {
        if (builderClass.isAssignableFrom(this.getClass())) {
            return builderClass.cast(this);
        }
        throw new IllegalArgumentException("Cannot provide an instance of " + builderClass.getName() + ", builder is: " + this.getClass().getName());
    }
}

