/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing;

import io.helidon.tracing.HeaderConsumer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Stream;

class MapHeaderConsumer
implements HeaderConsumer {
    private final Map<String, List<String>> delegate;
    private final Map<String, List<String>> caseInsensitiveShadow;
    private final Map<String, List<String>> mapToQuery;

    MapHeaderConsumer(Map<String, List<String>> headers) {
        this.delegate = headers;
        if (MapHeaderConsumer.isCaseInsensitive(headers)) {
            this.caseInsensitiveShadow = null;
            this.mapToQuery = this.delegate;
        } else {
            this.caseInsensitiveShadow = new ConcurrentSkipListMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            this.caseInsensitiveShadow.putAll(headers);
            this.mapToQuery = this.caseInsensitiveShadow;
        }
    }

    @Override
    public Iterable<String> keys() {
        return this.delegate.keySet();
    }

    @Override
    public Optional<String> get(String key) {
        return Optional.ofNullable(this.mapToQuery.get(key)).map(Collection::stream).flatMap(Stream::findFirst);
    }

    @Override
    public Iterable<String> getAll(String key) {
        return this.mapToQuery.getOrDefault(key, List.of());
    }

    @Override
    public boolean contains(String key) {
        return this.mapToQuery.containsKey(key);
    }

    @Override
    public void setIfAbsent(String key, String ... values) {
        List<String> valueList = List.of(values);
        this.delegate.putIfAbsent(key, valueList);
        if (this.caseInsensitiveShadow != null) {
            this.caseInsensitiveShadow.putIfAbsent(key, valueList);
        }
    }

    @Override
    public void set(String key, String ... values) {
        List<String> valueList = List.of(values);
        this.delegate.put(key, valueList);
        if (this.caseInsensitiveShadow != null) {
            this.caseInsensitiveShadow.put(key, valueList);
        }
    }

    private static boolean isCaseInsensitive(Map<String, List<String>> headers) {
        return headers instanceof TreeMap && ((TreeMap)headers).comparator() == String.CASE_INSENSITIVE_ORDER || headers instanceof ConcurrentSkipListMap && ((ConcurrentSkipListMap)headers).comparator() == String.CASE_INSENSITIVE_ORDER;
    }
}

