/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing;

import io.helidon.tracing.Scope;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tag;
import io.helidon.tracing.TracerProviderHelper;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;

public interface Span {
    public static Optional<Span> current() {
        return TracerProviderHelper.currentSpan();
    }

    default public void tag(Tag<?> tag) {
        tag.apply(this);
    }

    public void tag(String var1, String var2);

    public void tag(String var1, Boolean var2);

    public void tag(String var1, Number var2);

    public void status(Status var1);

    public SpanContext context();

    public void addEvent(String var1, Map<String, ?> var2);

    public void end();

    public void end(Throwable var1);

    public Scope activate();

    default public void addEvent(String logMessage) {
        this.addEvent(logMessage, Map.of());
    }

    default public <T> T unwrap(Class<T> spanClass) {
        try {
            return spanClass.cast(this);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("This span is not compatible with " + spanClass.getName());
        }
    }

    public static interface Builder<B extends Builder<B>>
    extends io.helidon.common.Builder<B, Span> {
        public B parent(SpanContext var1);

        public B kind(Kind var1);

        default public B tag(Tag<?> tag) {
            tag.apply(this);
            return (B)((Builder)this.identity());
        }

        public B tag(String var1, String var2);

        public B tag(String var1, Boolean var2);

        public B tag(String var1, Number var2);

        default public Span start() {
            return this.start(Instant.now());
        }

        public Span start(Instant var1);

        default public <T> T unwrap(Class<T> type) {
            if (type.isAssignableFrom(this.getClass())) {
                return type.cast(this);
            }
            throw new IllegalArgumentException("This instance cannot be unwrapped to " + type.getName() + ", this builder: " + this.getClass().getName());
        }
    }

    public static enum Status {
        UNSET,
        OK,
        ERROR;

    }

    public static enum Kind {
        INTERNAL,
        SERVER,
        CLIENT,
        PRODUCER,
        CONSUMER;

    }
}

