/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.providers.opentelemetry;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.LazyValue;
import io.helidon.config.Config;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.SpanListener;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.Wrapper;
import io.helidon.tracing.providers.opentelemetry.OpenTelemetrySpan;
import io.helidon.tracing.providers.opentelemetry.OpenTelemetrySpanBuilder;
import io.helidon.tracing.providers.opentelemetry.OpenTelemetrySpanContext;
import io.helidon.tracing.providers.opentelemetry.OpenTelemetryTracer;
import io.helidon.tracing.providers.opentelemetry.WrappedSpan;
import io.helidon.tracing.providers.opentelemetry.WrappedTracer;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;

public final class HelidonOpenTelemetry {
    public static final String OTEL_AGENT_PRESENT_PROPERTY = "otel.agent.present";
    public static final String IO_OPENTELEMETRY_JAVAAGENT = "io.opentelemetry.javaagent";
    static final String UNSUPPORTED_OPERATION_MESSAGE = "Span listener attempted to invoke an illegal operation";
    static final String USE_EXISTING_OTEL = "io.helidon.telemetry.otel.use-existing-instance";
    private static final System.Logger LOGGER = System.getLogger(HelidonOpenTelemetry.class.getName());
    private static final LazyValue<List<SpanListener>> SPAN_LISTENERS = LazyValue.create(() -> HelidonServiceLoader.create(ServiceLoader.load(SpanListener.class)).asList());

    private HelidonOpenTelemetry() {
    }

    public static OpenTelemetryTracer create(OpenTelemetry telemetry, io.opentelemetry.api.trace.Tracer tracer, Map<String, String> tags) {
        return new OpenTelemetryTracer(telemetry, tracer, tags);
    }

    public static Span create(io.opentelemetry.api.trace.Span span) {
        return new OpenTelemetrySpan(span, (List)SPAN_LISTENERS.get());
    }

    public static Span create(io.opentelemetry.api.trace.Span span, Baggage baggage) {
        return new OpenTelemetrySpan(span, baggage, (List)SPAN_LISTENERS.get());
    }

    public static Span.Builder<?> create(SpanBuilder spanBuilder, Tracer helidonTracer) {
        return new OpenTelemetrySpanBuilder(spanBuilder, ((OpenTelemetryTracer)helidonTracer.unwrap(OpenTelemetryTracer.class)).spanListeners());
    }

    public static SpanContext create(Context context) {
        return new OpenTelemetrySpanContext(context);
    }

    public static <T extends io.opentelemetry.api.trace.Tracer & Wrapper> T callbackEnabledFrom(io.opentelemetry.api.trace.Tracer otelTracer) {
        return HelidonOpenTelemetry.callbackEnabledFrom(new OpenTelemetryTracer(GlobalOpenTelemetry.get(), otelTracer, Map.of()));
    }

    public static <T extends io.opentelemetry.api.trace.Tracer & Wrapper> T callbackEnabledFrom(Tracer helidonTracer) {
        return (T)WrappedTracer.create(helidonTracer);
    }

    public static <T extends io.opentelemetry.api.trace.Span & Wrapper> T callbackEnabledFrom(io.opentelemetry.api.trace.Span otelSpan) {
        return (T)WrappedSpan.create(HelidonOpenTelemetry.create(otelSpan));
    }

    public static <T extends io.opentelemetry.api.trace.Span & Wrapper> T callbackEnabledFrom(Span helidonSpan) {
        return (T)WrappedSpan.create(helidonSpan);
    }

    public static void invokeListeners(Span helidonSpan, System.Logger logger, Consumer<SpanListener> operation) {
        HelidonOpenTelemetry.invokeListeners(((OpenTelemetrySpan)helidonSpan.unwrap(OpenTelemetrySpan.class)).spanListeners(), logger, operation);
    }

    static void invokeListeners(List<SpanListener> spanListeners, System.Logger logger, Consumer<SpanListener> operation) {
        if (spanListeners.isEmpty()) {
            return;
        }
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        for (SpanListener listener : spanListeners) {
            try {
                operation.accept(listener);
            }
            catch (Throwable t) {
                throwables.add(t);
            }
        }
        Throwable throwableToLog = null;
        if (throwables.size() == 1) {
            throwableToLog = (Throwable)throwables.getFirst();
        } else if (!throwables.isEmpty()) {
            throwableToLog = new RuntimeException();
            throwables.forEach(throwableToLog::addSuppressed);
        }
        if (throwableToLog != null) {
            logger.log(System.Logger.Level.WARNING, "Error(s) from listener(s)", throwableToLog);
        }
    }

    public static final class AgentDetector {
        private AgentDetector() {
        }

        public static boolean isAgentPresent(Config config) {
            Optional agentPresent;
            if (config != null && (agentPresent = config.get(HelidonOpenTelemetry.OTEL_AGENT_PRESENT_PROPERTY).asBoolean().asOptional()).isPresent()) {
                return (Boolean)agentPresent.get();
            }
            if (AgentDetector.checkContext() || AgentDetector.checkSystemProperties()) {
                if (LOGGER.isLoggable(System.Logger.Level.INFO)) {
                    LOGGER.log(System.Logger.Level.INFO, "OpenTelemetry Agent detected");
                }
                return true;
            }
            return false;
        }

        public static boolean useExistingGlobalOpenTelemetry(Config config) {
            return AgentDetector.isAgentPresent(config) || (Boolean)config.get(HelidonOpenTelemetry.USE_EXISTING_OTEL).asBoolean().orElse((Object)false) != false;
        }

        private static boolean checkSystemProperties() {
            return System.getProperties().stringPropertyNames().stream().anyMatch(property -> property.contains(HelidonOpenTelemetry.IO_OPENTELEMETRY_JAVAAGENT));
        }

        private static boolean checkContext() {
            return Context.current().getClass().getName().contains("agent");
        }
    }
}

