/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.providers.opentelemetry;

import io.helidon.tracing.WritableBaggage;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.baggage.BaggageBuilder;
import io.opentelemetry.api.baggage.BaggageEntry;
import io.opentelemetry.api.baggage.BaggageEntryMetadata;
import io.opentelemetry.context.Context;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;

class MutableOpenTelemetryBaggage
implements Baggage,
WritableBaggage {
    private final Map<String, BaggageEntry> values = new LinkedHashMap<String, BaggageEntry>();

    static MutableOpenTelemetryBaggage fromContext(Context context) {
        MutableOpenTelemetryBaggage result = new MutableOpenTelemetryBaggage();
        result.values.putAll(Baggage.fromContext((Context)context).asMap());
        return result;
    }

    MutableOpenTelemetryBaggage() {
    }

    private MutableOpenTelemetryBaggage(Builder builder) {
        this.values.putAll(builder.values);
    }

    public int size() {
        return this.values.size();
    }

    public void forEach(BiConsumer<? super String, ? super BaggageEntry> consumer) {
        this.values.forEach(consumer);
    }

    public Map<String, BaggageEntry> asMap() {
        return Collections.unmodifiableMap(this.values);
    }

    public String getEntryValue(String entryKey) {
        Objects.requireNonNull(entryKey, "baggage key cannot be null");
        BaggageEntry entry = this.values.get(entryKey);
        return entry != null ? entry.getValue() : null;
    }

    public BaggageBuilder toBuilder() {
        return new Builder(this.values);
    }

    void baggage(String key, String value) {
        this.baggage(key, value, "");
    }

    void baggage(String key, String value, String metadata) {
        Objects.requireNonNull(key, "baggage key cannot be null");
        Objects.requireNonNull(value, "baggage value cannot be null");
        this.values.put(key, new HBaggageEntry(value, new HBaggageEntryMetadata(metadata)));
    }

    public Optional<String> get(String key) {
        BaggageEntry baggageEntry = this.values.get(key);
        return baggageEntry == null ? Optional.empty() : Optional.ofNullable(baggageEntry.getValue());
    }

    public Set<String> keys() {
        return Collections.unmodifiableSet(this.values.keySet());
    }

    public boolean containsKey(String key) {
        Objects.requireNonNull(key, "baggage key cannot be null");
        return this.values.containsKey(key);
    }

    public WritableBaggage set(String key, String value) {
        return this.set(key, value, "");
    }

    public WritableBaggage set(String key, String value, String metadata) {
        this.baggage(key, value, metadata);
        return this;
    }

    static class Builder
    implements BaggageBuilder {
        private final Map<String, BaggageEntry> values = new HashMap<String, BaggageEntry>();

        private Builder(Map<String, BaggageEntry> values) {
            this.values.putAll(values);
        }

        public BaggageBuilder put(String key, String value, BaggageEntryMetadata entryMetadata) {
            Objects.requireNonNull(key, "baggage key cannot be null");
            Objects.requireNonNull(value, "baggage value cannot be null");
            this.values.put(key, new HBaggageEntry(value, entryMetadata));
            return this;
        }

        public BaggageBuilder remove(String key) {
            Objects.requireNonNull(key, "baggage key cannot be null");
            this.values.remove(key);
            return this;
        }

        public Baggage build() {
            return new MutableOpenTelemetryBaggage(this);
        }
    }

    static class HBaggageEntry
    implements BaggageEntry {
        private final String value;
        private final BaggageEntryMetadata metadata;

        HBaggageEntry(String value, BaggageEntryMetadata metadata) {
            this.value = value;
            this.metadata = metadata;
        }

        public String getValue() {
            return this.value;
        }

        public BaggageEntryMetadata getMetadata() {
            return this.metadata;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HBaggageEntry)) {
                return false;
            }
            HBaggageEntry that = (HBaggageEntry)o;
            return Objects.equals(this.value, that.value) && Objects.equals(this.metadata, that.metadata);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.metadata);
        }
    }

    static class HBaggageEntryMetadata
    implements BaggageEntryMetadata {
        private final String metadata;

        HBaggageEntryMetadata(String metadata) {
            this.metadata = metadata;
        }

        public String getValue() {
            return this.metadata;
        }
    }
}

