/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.providers.opentelemetry;

import io.helidon.common.context.Contexts;
import io.helidon.common.context.spi.DataPropagationProvider;
import io.helidon.tracing.Scope;
import io.helidon.tracing.Span;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.providers.opentelemetry.OpenTelemetryTracerProvider;

public class OpenTelemetryDataPropagationProvider
implements DataPropagationProvider<OpenTelemetryContext> {
    private static final System.Logger LOGGER = System.getLogger(OpenTelemetryDataPropagationProvider.class.getName());

    public OpenTelemetryContext data() {
        Tracer tracer = Contexts.context().flatMap(ctx -> ctx.get(Tracer.class)).orElseGet(Tracer::global);
        Span span = OpenTelemetryTracerProvider.activeSpan().orElse(null);
        return new OpenTelemetryContext(tracer, span);
    }

    public void clearData(OpenTelemetryContext context) {
        if (context != null && context.scope != null) {
            try {
                context.scope.close();
            }
            catch (Exception e) {
                LOGGER.log(System.Logger.Level.TRACE, "Cannot close tracing span", (Throwable)e);
            }
        }
    }

    public void propagateData(OpenTelemetryContext context) {
        if (context != null && context.span != null) {
            context.scope = context.span.activate();
        }
    }

    public static class OpenTelemetryContext {
        private final Span span;
        private final Tracer tracer;
        private Scope scope;

        protected OpenTelemetryContext(Tracer tracer, Span span) {
            this.tracer = tracer;
            this.span = span;
        }

        public Scope scope() {
            return this.scope;
        }

        public Tracer tracer() {
            return this.tracer;
        }

        public Span span() {
            return this.span;
        }
    }
}

