/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.providers.opentelemetry;

import io.helidon.tracing.Scope;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanListener;
import io.helidon.tracing.providers.opentelemetry.HelidonOpenTelemetry;
import io.helidon.tracing.providers.opentelemetry.OpenTelemetrySpan;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

class OpenTelemetryScope
implements Scope {
    private static final System.Logger LOGGER = System.getLogger(OpenTelemetryScope.class.getName());
    private final OpenTelemetrySpan span;
    private final io.opentelemetry.context.Scope delegate;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final List<SpanListener> spanListeners;
    private Limited limited;

    OpenTelemetryScope(OpenTelemetrySpan span, io.opentelemetry.context.Scope scope, List<SpanListener> spanListeners) {
        this.span = span;
        this.delegate = scope;
        this.spanListeners = spanListeners;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true) && this.delegate != null) {
            this.delegate.close();
            HelidonOpenTelemetry.invokeListeners(this.spanListeners, LOGGER, listener -> listener.closed((Span)this.span.limited(), (Scope)this.limited()));
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    Limited limited() {
        if (this.limited != null) {
            return this.limited;
        }
        if (this.spanListeners.isEmpty()) {
            return null;
        }
        this.limited = new Limited(this);
        return this.limited;
    }

    private record Limited(OpenTelemetryScope delegate) implements Scope
    {
        public void close() {
            throw new SpanListener.ForbiddenOperationException();
        }

        public boolean isClosed() {
            return this.delegate.isClosed();
        }
    }
}

