/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.providers.opentelemetry;

import io.helidon.common.context.Contexts;
import io.helidon.tracing.Scope;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.SpanListener;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.WritableBaggage;
import io.helidon.tracing.providers.opentelemetry.HelidonOpenTelemetry;
import io.helidon.tracing.providers.opentelemetry.MutableOpenTelemetryBaggage;
import io.helidon.tracing.providers.opentelemetry.OpenTelemetryScope;
import io.helidon.tracing.providers.opentelemetry.OpenTelemetrySpanContext;
import io.helidon.tracing.providers.opentelemetry.OpenTelemetryTracer;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class OpenTelemetrySpan
implements Span {
    private static final System.Logger LOGGER = System.getLogger(OpenTelemetrySpan.class.getName());
    private final io.opentelemetry.api.trace.Span delegate;
    private final Baggage baggage;
    private final List<SpanListener> spanListeners;
    private Limited limited;

    OpenTelemetrySpan(io.opentelemetry.api.trace.Span span, List<SpanListener> spanListeners) {
        this(span, new MutableOpenTelemetryBaggage(), spanListeners);
    }

    OpenTelemetrySpan(Tracer helidonTracer, io.opentelemetry.api.trace.Span span, boolean isNoop) {
        this(span, isNoop ? List.of() : ((OpenTelemetryTracer)helidonTracer.unwrap(OpenTelemetryTracer.class)).spanListeners());
    }

    OpenTelemetrySpan(io.opentelemetry.api.trace.Span span, Baggage baggage, List<SpanListener> spanListeners) {
        this.delegate = span;
        this.baggage = baggage;
        this.spanListeners = spanListeners;
    }

    public Span tag(String key, String value) {
        this.delegate.setAttribute(key, value);
        return this;
    }

    public Span tag(String key, Boolean value) {
        this.delegate.setAttribute(key, value.booleanValue());
        return this;
    }

    public Span tag(String key, Number value) {
        if (value instanceof Double || value instanceof Float) {
            this.delegate.setAttribute(key, value.doubleValue());
        } else {
            this.delegate.setAttribute(key, value.longValue());
        }
        return this;
    }

    public void status(Span.Status status) {
        switch (status) {
            case OK: {
                this.delegate.setStatus(StatusCode.OK);
                break;
            }
            case ERROR: {
                this.delegate.setStatus(StatusCode.ERROR);
                break;
            }
        }
    }

    public SpanContext context() {
        return new OpenTelemetrySpanContext(this.otelContextWithSpanAndBaggage());
    }

    public void addEvent(String name, Map<String, ?> attributes) {
        this.delegate.addEvent(name, this.toAttributes(attributes));
    }

    public void end() {
        this.delegate.end();
        HelidonOpenTelemetry.invokeListeners(this.spanListeners, LOGGER, listener -> listener.ended((Span)this.limited()));
    }

    public void end(Throwable t) {
        this.delegate.recordException(t);
        this.delegate.setStatus(StatusCode.ERROR);
        this.delegate.end();
        HelidonOpenTelemetry.invokeListeners(this.spanListeners, LOGGER, listener -> listener.ended((Span)this.limited(), t));
    }

    public Scope activate() {
        io.opentelemetry.context.Scope scope = this.otelContextWithSpanAndBaggage().makeCurrent();
        OpenTelemetryScope result = new OpenTelemetryScope(this, scope, this.spanListeners);
        HelidonOpenTelemetry.invokeListeners(this.spanListeners, LOGGER, listener -> listener.activated((Span)this.limited(), (Scope)result.limited()));
        return result;
    }

    public Span baggage(String key, String value) {
        Baggage baggage = this.baggage;
        if (!(baggage instanceof WritableBaggage)) {
            throw new SpanListener.ForbiddenOperationException("Attempt to set baggage on a span with read-only baggage (perhaps from context");
        }
        WritableBaggage writableBaggage = (WritableBaggage)baggage;
        writableBaggage.set(key, value);
        return this;
    }

    public Optional<String> baggage(String key) {
        return Optional.ofNullable(this.baggage.getEntryValue(key));
    }

    public WritableBaggage baggage() {
        WritableBaggage writableBaggage;
        Baggage baggage = this.baggage;
        return baggage instanceof WritableBaggage ? (writableBaggage = (WritableBaggage)baggage) : OpenTelemetrySpan.writableBaggage(this.baggage);
    }

    public <T> T unwrap(Class<T> spanClass) {
        if (spanClass.isInstance(this.delegate)) {
            return spanClass.cast(this.delegate);
        }
        if (spanClass.isInstance(this)) {
            return spanClass.cast(this);
        }
        throw new IllegalArgumentException("Cannot provide an instance of " + spanClass.getName() + ", telemetry span is: " + this.delegate.getClass().getName());
    }

    List<SpanListener> spanListeners() {
        return List.copyOf(this.spanListeners);
    }

    Limited limited() {
        if (this.limited != null) {
            return this.limited;
        }
        if (this.spanListeners.isEmpty()) {
            return null;
        }
        this.limited = new Limited(this);
        return this.limited;
    }

    private static Context getContext() {
        return Contexts.context().flatMap(ctx -> ctx.get(Context.class)).orElseGet(Context::current);
    }

    private static WritableBaggage writableBaggage(final Baggage baggage) {
        return new WritableBaggage(){

            public WritableBaggage set(String key, String value) {
                throw new SpanListener.ForbiddenOperationException("Attempt to modify read-only baggage");
            }

            public Optional<String> get(String key) {
                return Optional.ofNullable(baggage.getEntryValue(key));
            }

            public Set<String> keys() {
                return baggage.asMap().keySet();
            }

            public boolean containsKey(String key) {
                return baggage.asMap().containsKey(key);
            }
        };
    }

    private Context otelContextWithSpanAndBaggage() {
        return OpenTelemetrySpan.getContext().with((ImplicitContextKeyed)this.delegate).with((ImplicitContextKeyed)this.baggage);
    }

    private Attributes toAttributes(Map<String, ?> attributes) {
        AttributesBuilder builder = Attributes.builder();
        attributes.forEach((key, value) -> {
            if (value instanceof Long) {
                Long l = (Long)value;
                builder.put(key, l.longValue());
            } else if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                builder.put(key, b.booleanValue());
            } else if (value instanceof Double) {
                Double d = (Double)value;
                builder.put(key, d.doubleValue());
            } else {
                builder.put(key, String.valueOf(value));
            }
        });
        return builder.build();
    }

    private record Limited(OpenTelemetrySpan delegate) implements Span
    {
        public Span tag(String key, String value) {
            this.delegate.tag(key, value);
            return this;
        }

        public Span tag(String key, Boolean value) {
            this.delegate.tag(key, value);
            return this;
        }

        public Span tag(String key, Number value) {
            this.delegate.tag(key, value);
            return this;
        }

        public void status(Span.Status status) {
            throw new SpanListener.ForbiddenOperationException();
        }

        public SpanContext context() {
            return this.delegate.context();
        }

        public void addEvent(String name, Map<String, ?> attributes) {
            this.delegate.addEvent(name, attributes);
        }

        public void end() {
            throw new SpanListener.ForbiddenOperationException();
        }

        public void end(Throwable t) {
            throw new SpanListener.ForbiddenOperationException();
        }

        public Scope activate() {
            throw new SpanListener.ForbiddenOperationException();
        }

        public Span baggage(String key, String value) {
            this.delegate.baggage().set(key, value);
            return this;
        }

        public Optional<String> baggage(String key) {
            return this.delegate.baggage().get(key);
        }

        public WritableBaggage baggage() {
            return this.delegate.baggage();
        }

        public <T> T unwrap(Class<T> spanClass) {
            if (spanClass.isInstance(this)) {
                return spanClass.cast(this);
            }
            return this.delegate.unwrap(spanClass);
        }
    }
}

