/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.providers.opentelemetry;

import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.SpanListener;
import io.helidon.tracing.providers.opentelemetry.HelidonOpenTelemetry;
import io.helidon.tracing.providers.opentelemetry.OpenTelemetrySpan;
import io.helidon.tracing.providers.opentelemetry.OpenTelemetrySpanContext;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.List;

class OpenTelemetrySpanBuilder
implements Span.Builder<OpenTelemetrySpanBuilder> {
    private static final System.Logger LOGGER = System.getLogger(OpenTelemetrySpanBuilder.class.getName());
    private final SpanBuilder spanBuilder;
    private final List<SpanListener> spanListeners;
    private Limited limited;
    private boolean parentSet;
    private Baggage parentBaggage;

    OpenTelemetrySpanBuilder(SpanBuilder spanBuilder, List<SpanListener> spanListeners) {
        this.spanBuilder = spanBuilder;
        this.spanListeners = spanListeners;
    }

    public Span build() {
        return this.start();
    }

    public OpenTelemetrySpanBuilder parent(SpanContext spanContext) {
        this.parentSet = true;
        spanContext.asParent((Span.Builder)this);
        this.parentBaggage = Baggage.fromContext((Context)((OpenTelemetrySpanContext)spanContext).openTelemetry());
        return this;
    }

    public OpenTelemetrySpanBuilder kind(Span.Kind kind) {
        switch (kind) {
            case SERVER: {
                this.spanBuilder.setSpanKind(SpanKind.SERVER);
                break;
            }
            case CLIENT: {
                this.spanBuilder.setSpanKind(SpanKind.CLIENT);
                break;
            }
            case PRODUCER: {
                this.spanBuilder.setSpanKind(SpanKind.PRODUCER);
                break;
            }
            case CONSUMER: {
                this.spanBuilder.setSpanKind(SpanKind.CONSUMER);
                break;
            }
            default: {
                this.spanBuilder.setSpanKind(SpanKind.INTERNAL);
            }
        }
        return this;
    }

    public OpenTelemetrySpanBuilder tag(String key, String value) {
        this.spanBuilder.setAttribute(key, value);
        return this;
    }

    public OpenTelemetrySpanBuilder tag(String key, Boolean value) {
        this.spanBuilder.setAttribute(key, value.booleanValue());
        return this;
    }

    public OpenTelemetrySpanBuilder tag(String key, Number value) {
        if (value instanceof Double || value instanceof Float) {
            this.spanBuilder.setAttribute(key, value.doubleValue());
        } else {
            this.spanBuilder.setAttribute(key, value.longValue());
        }
        return this;
    }

    public Span start(Instant instant) {
        if (!this.parentSet) {
            this.spanBuilder.setNoParent();
        }
        this.spanBuilder.setStartTimestamp(instant);
        HelidonOpenTelemetry.invokeListeners(this.spanListeners, LOGGER, listener -> listener.starting((Span.Builder)this.limited()));
        io.opentelemetry.api.trace.Span span = this.spanBuilder.startSpan();
        OpenTelemetrySpan result = new OpenTelemetrySpan(span, this.spanListeners);
        if (this.parentBaggage != null) {
            this.parentBaggage.forEach((key, baggageEntry) -> result.baggage().set(key, baggageEntry.getValue(), baggageEntry.getMetadata().getValue()));
        }
        HelidonOpenTelemetry.invokeListeners(this.spanListeners, LOGGER, listener -> listener.started((Span)result.limited()));
        return result;
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this.spanBuilder)) {
            return type.cast(this.spanBuilder);
        }
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        throw new IllegalArgumentException("Cannot provide an instance of " + type.getName() + ", span builder is: " + this.spanBuilder.getClass().getName());
    }

    void parent(Context context) {
        this.parentSet = true;
        this.spanBuilder.setParent(context);
    }

    Limited limited() {
        if (this.limited != null) {
            return this.limited;
        }
        if (this.spanListeners.isEmpty()) {
            return null;
        }
        this.limited = new Limited(this);
        return this.limited;
    }

    private record Limited(OpenTelemetrySpanBuilder delegate) implements Span.Builder<Limited>
    {
        public Span build() {
            throw new SpanListener.ForbiddenOperationException();
        }

        public Limited parent(SpanContext spanContext) {
            throw new SpanListener.ForbiddenOperationException();
        }

        public Limited kind(Span.Kind kind) {
            throw new SpanListener.ForbiddenOperationException();
        }

        public Limited tag(String key, String value) {
            this.delegate.tag(key, value);
            return this;
        }

        public Limited tag(String key, Boolean value) {
            this.delegate.tag(key, value);
            return this;
        }

        public Limited tag(String key, Number value) {
            this.delegate.tag(key, value);
            return this;
        }

        public Span start(Instant instant) {
            throw new SpanListener.ForbiddenOperationException();
        }
    }
}

