/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.providers.opentelemetry;

import io.helidon.tracing.Baggage;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.providers.opentelemetry.MutableOpenTelemetryBaggage;
import io.helidon.tracing.providers.opentelemetry.OpenTelemetrySpanBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;

class OpenTelemetrySpanContext
implements SpanContext {
    private final Context context;
    private final Baggage baggage;

    OpenTelemetrySpanContext(Context context) {
        this.context = context;
        this.baggage = MutableOpenTelemetryBaggage.fromContext(context);
    }

    public String traceId() {
        return Span.fromContext((Context)this.context).getSpanContext().getTraceId();
    }

    public String spanId() {
        return Span.fromContext((Context)this.context).getSpanContext().getSpanId();
    }

    public void asParent(Span.Builder<?> spanBuilder) {
        ((OpenTelemetrySpanBuilder)spanBuilder.unwrap(OpenTelemetrySpanBuilder.class)).parent(this.context);
    }

    Context openTelemetry() {
        return this.context;
    }

    public Baggage baggage() {
        return this.baggage;
    }
}

