/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.providers.opentelemetry;

import io.helidon.tracing.Span;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.Wrapper;
import io.helidon.tracing.providers.opentelemetry.HelidonOpenTelemetry;
import io.helidon.tracing.providers.opentelemetry.OpenTelemetrySpan;
import io.helidon.tracing.providers.opentelemetry.WrappedScope;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

class WrappedSpan
implements io.opentelemetry.api.trace.Span,
Wrapper {
    private static final System.Logger LOGGER = System.getLogger(WrappedSpan.class.getName());
    private final Span helidonSpan;
    private final io.opentelemetry.api.trace.Span nativeSpan;

    static WrappedSpan create(Span helidonSpan) {
        return new WrappedSpan(helidonSpan);
    }

    private WrappedSpan(Span helidonSpan) {
        this.helidonSpan = helidonSpan;
        this.nativeSpan = (io.opentelemetry.api.trace.Span)helidonSpan.unwrap(io.opentelemetry.api.trace.Span.class);
    }

    private WrappedSpan(Tracer helidonTracer) {
        io.opentelemetry.api.trace.Span nativeCurrentSpan = io.opentelemetry.api.trace.Span.fromContextOrNull((Context)Context.current());
        this.nativeSpan = io.opentelemetry.api.trace.Span.current();
        this.helidonSpan = new OpenTelemetrySpan(helidonTracer, this.nativeSpan, nativeCurrentSpan == null);
    }

    public <T> io.opentelemetry.api.trace.Span setAttribute(AttributeKey<T> key, T value) {
        this.nativeSpan.setAttribute(key, value);
        return this;
    }

    public io.opentelemetry.api.trace.Span addEvent(String name, Attributes attributes) {
        this.nativeSpan.addEvent(name, attributes);
        return this;
    }

    public io.opentelemetry.api.trace.Span addEvent(String name, Attributes attributes, long timestamp, TimeUnit unit) {
        this.nativeSpan.addEvent(name, attributes, timestamp, unit);
        return this;
    }

    public io.opentelemetry.api.trace.Span setStatus(StatusCode statusCode, String description) {
        this.nativeSpan.setStatus(statusCode, description);
        return this;
    }

    public io.opentelemetry.api.trace.Span recordException(Throwable exception, Attributes additionalAttributes) {
        this.nativeSpan.recordException(exception, additionalAttributes);
        return this;
    }

    public io.opentelemetry.api.trace.Span updateName(String name) {
        this.nativeSpan.updateName(name);
        return this;
    }

    public void end() {
        this.helidonSpan.end();
    }

    public void end(long timestamp, TimeUnit unit) {
        this.nativeSpan.end(timestamp, unit);
        HelidonOpenTelemetry.invokeListeners(this.helidonSpan, LOGGER, listener -> listener.ended(this.helidonSpan));
    }

    public SpanContext getSpanContext() {
        return this.nativeSpan.getSpanContext();
    }

    public boolean isRecording() {
        return this.nativeSpan.isRecording();
    }

    public Scope makeCurrent() {
        return WrappedScope.create(this.helidonSpan.activate());
    }

    public <R> R unwrap(Class<? extends R> c) {
        if (c.isInstance(this.nativeSpan)) {
            return c.cast(this.nativeSpan);
        }
        if (c.isInstance(this.helidonSpan)) {
            return c.cast(this.helidonSpan);
        }
        throw new IllegalArgumentException("Cannot provide an instance of " + c.getName() + "; the wrapped telemetry span has type " + this.nativeSpan.getClass().getName() + " and the wrapped Helidon span has type " + this.helidonSpan.getClass().getName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof WrappedSpan)) {
            return false;
        }
        WrappedSpan that = (WrappedSpan)o;
        return Objects.equals(this.helidonSpan, that.helidonSpan) && Objects.equals(this.nativeSpan, that.nativeSpan);
    }

    public int hashCode() {
        return Objects.hash(this.helidonSpan, this.nativeSpan);
    }
}

