/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.providers.opentelemetry;

import io.helidon.tracing.Span;
import io.helidon.tracing.Tracer;
import io.helidon.tracing.Wrapper;
import io.helidon.tracing.providers.opentelemetry.HelidonOpenTelemetry;
import io.helidon.tracing.providers.opentelemetry.WrappedSpan;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

class WrappedSpanBuilder
implements SpanBuilder,
Wrapper {
    private final Span.Builder<?> helidonSpanBuilder;
    private final SpanBuilder nativeSpanBuilder;

    static WrappedSpanBuilder create(Tracer helidonTracer, String spanName) {
        return WrappedSpanBuilder.create(helidonTracer.spanBuilder(spanName));
    }

    static WrappedSpanBuilder create(Span.Builder<?> helidonSpanBuilder) {
        return new WrappedSpanBuilder((SpanBuilder)helidonSpanBuilder.unwrap(SpanBuilder.class), helidonSpanBuilder);
    }

    private WrappedSpanBuilder(SpanBuilder otelSpanBuilder, Span.Builder<?> helidonSpanBuilder) {
        this.nativeSpanBuilder = otelSpanBuilder;
        this.helidonSpanBuilder = helidonSpanBuilder;
        Span.current().map(Span::context).ifPresent(arg_0 -> helidonSpanBuilder.parent(arg_0));
    }

    public SpanBuilder setParent(Context context) {
        this.nativeSpanBuilder.setParent(context);
        this.helidonSpanBuilder.parent(HelidonOpenTelemetry.create(context));
        return this;
    }

    public SpanBuilder setNoParent() {
        this.nativeSpanBuilder.setNoParent();
        return this;
    }

    public SpanBuilder addLink(SpanContext spanContext) {
        this.nativeSpanBuilder.addLink(spanContext);
        return this;
    }

    public SpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
        this.nativeSpanBuilder.addLink(spanContext, attributes);
        return this;
    }

    public SpanBuilder setAttribute(String key, String value) {
        this.nativeSpanBuilder.setAttribute(key, value);
        return this;
    }

    public SpanBuilder setAttribute(String key, long value) {
        this.nativeSpanBuilder.setAttribute(key, value);
        return this;
    }

    public SpanBuilder setAttribute(String key, double value) {
        this.nativeSpanBuilder.setAttribute(key, value);
        this.helidonSpanBuilder.tag(key, (Number)value);
        return this;
    }

    public SpanBuilder setAttribute(String key, boolean value) {
        this.nativeSpanBuilder.setAttribute(key, value);
        return this;
    }

    public <T> SpanBuilder setAttribute(AttributeKey<T> key, T value) {
        this.nativeSpanBuilder.setAttribute(key, value);
        return this;
    }

    public SpanBuilder setSpanKind(SpanKind spanKind) {
        this.nativeSpanBuilder.setSpanKind(spanKind);
        return this;
    }

    public SpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
        this.nativeSpanBuilder.setStartTimestamp(startTimestamp, unit);
        return this;
    }

    public io.opentelemetry.api.trace.Span startSpan() {
        return WrappedSpan.create(this.helidonSpanBuilder.start());
    }

    public <R> R unwrap(Class<? extends R> c) {
        if (c.isInstance(this.helidonSpanBuilder)) {
            return c.cast(this.helidonSpanBuilder);
        }
        if (c.isInstance(this.nativeSpanBuilder)) {
            return c.cast(this.nativeSpanBuilder);
        }
        throw new IllegalArgumentException("Cannot provide an instance of " + c.getName() + "; the wrapped telemetry span builder has type " + this.nativeSpanBuilder.getClass().getName() + " and the wrapped Helidon span builder has type " + this.helidonSpanBuilder.getClass().getName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof WrappedSpanBuilder)) {
            return false;
        }
        WrappedSpanBuilder that = (WrappedSpanBuilder)o;
        return Objects.equals(this.helidonSpanBuilder, that.helidonSpanBuilder) && Objects.equals(this.nativeSpanBuilder, that.nativeSpanBuilder);
    }

    public int hashCode() {
        return Objects.hash(this.helidonSpanBuilder, this.nativeSpanBuilder);
    }
}

