/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.tracing.providers.opentelemetry;

import io.helidon.tracing.Tracer;
import io.helidon.tracing.Wrapper;
import io.helidon.tracing.providers.opentelemetry.WrappedSpanBuilder;
import io.opentelemetry.api.trace.SpanBuilder;
import java.util.Objects;

class WrappedTracer
implements io.opentelemetry.api.trace.Tracer,
Wrapper {
    private final Tracer helidonTracer;

    static WrappedTracer create(Tracer helidonTracer) {
        return new WrappedTracer(helidonTracer);
    }

    private WrappedTracer(Tracer helidonTracer) {
        this.helidonTracer = helidonTracer;
    }

    public SpanBuilder spanBuilder(String spanName) {
        return WrappedSpanBuilder.create(this.helidonTracer, spanName);
    }

    public <R> R unwrap(Class<? extends R> c) {
        if (c.isInstance(this.helidonTracer)) {
            return c.cast(this.helidonTracer);
        }
        Object otelTracer = this.helidonTracer.unwrap(c);
        if (c.isInstance(otelTracer)) {
            return c.cast(otelTracer);
        }
        throw new IllegalArgumentException("Cannot provide an instance of " + c.getName() + "; the wrapped telemetry tracer has type " + otelTracer.getClass().getName() + " and the wrapped Helidon tracer has type " + this.helidonTracer.getClass().getName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof WrappedTracer)) {
            return false;
        }
        WrappedTracer that = (WrappedTracer)o;
        return Objects.equals(this.helidonTracer, that.helidonTracer);
    }

    public int hashCode() {
        return Objects.hashCode(this.helidonTracer);
    }
}

