/*
 * Copyright (c) 2024 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.webclient.http1;

import java.util.Objects;
import java.util.Optional;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;

/**
 * Configuration of an HTTP/1.1 client.
 *
 * @see #builder()
 * @see #create()
 */
@Generated(value = "io.helidon.builder.codegen.BuilderCodegen", trigger = "io.helidon.webclient.http1.Http1ClientProtocolConfigBlueprint")
public interface Http1ClientProtocolConfig extends Http1ClientProtocolConfigBlueprint, Prototype.Api {

    /**
     * Create a new fluent API builder to customize configuration.
     *
     * @return a new builder
     */
    static Http1ClientProtocolConfig.Builder builder() {
        return new Http1ClientProtocolConfig.Builder();
    }

    /**
     * Create a new fluent API builder from an existing instance.
     *
     * @param instance an existing instance used as a base for the builder
     * @return a builder based on an instance
     */
    static Http1ClientProtocolConfig.Builder builder(Http1ClientProtocolConfig instance) {
        return Http1ClientProtocolConfig.builder().from(instance);
    }

    /**
     * Create a new instance from configuration.
     *
     * @param config used to configure the new instance
     * @return a new instance configured from configuration
     */
    static Http1ClientProtocolConfig create(Config config) {
        return Http1ClientProtocolConfig.builder().config(config).buildPrototype();
    }

    /**
     * Create a new instance with default values.
     *
     * @return a new instance
     */
    static Http1ClientProtocolConfig create() {
        return Http1ClientProtocolConfig.builder().buildPrototype();
    }

    /**
     * Fluent API builder base for {@link Http1ClientProtocolConfig}.
     *
     * @param <BUILDER> type of the builder extending this abstract builder
     * @param <PROTOTYPE> type of the prototype interface that would be built by {@link #buildPrototype()}
     */
    abstract class BuilderBase<BUILDER extends Http1ClientProtocolConfig.BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends Http1ClientProtocolConfig> implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {

        private boolean defaultKeepAlive = true;
        private boolean validateRequestHeaders = false;
        private boolean validateResponseHeaders = true;
        private Config config;
        private int maxHeaderSize = 16384;
        private int maxStatusLineLength = 256;
        private String name = "http_1_1";

        /**
         * Protected to support extensibility.
         */
        protected BuilderBase() {
        }

        /**
         * Update this builder from an existing prototype instance. This method disables automatic service discovery.
         *
         * @param prototype existing prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(Http1ClientProtocolConfig prototype) {
            name(prototype.name());
            defaultKeepAlive(prototype.defaultKeepAlive());
            maxHeaderSize(prototype.maxHeaderSize());
            maxStatusLineLength(prototype.maxStatusLineLength());
            validateRequestHeaders(prototype.validateRequestHeaders());
            validateResponseHeaders(prototype.validateResponseHeaders());
            return self();
        }

        /**
         * Update this builder from an existing prototype builder instance.
         *
         * @param builder existing builder prototype to update this builder from
         * @return updated builder instance
         */
        public BUILDER from(Http1ClientProtocolConfig.BuilderBase<?, ?> builder) {
            name(builder.name());
            defaultKeepAlive(builder.defaultKeepAlive());
            maxHeaderSize(builder.maxHeaderSize());
            maxStatusLineLength(builder.maxStatusLineLength());
            validateRequestHeaders(builder.validateRequestHeaders());
            validateResponseHeaders(builder.validateResponseHeaders());
            return self();
        }

        /**
         * Update builder from configuration (node of this type).
         * If a value is present in configuration, it would override currently configured values.
         *
         * @param config configuration instance used to obtain values to update this builder
         * @return updated builder instance
         */
        @Override
        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("name").as(String.class).ifPresent(this::name);
            config.get("default-keep-alive").as(Boolean.class).ifPresent(this::defaultKeepAlive);
            config.get("max-header-size").as(Integer.class).ifPresent(this::maxHeaderSize);
            config.get("max-status-line-length").as(Integer.class).ifPresent(this::maxStatusLineLength);
            config.get("validate-request-headers").as(Boolean.class).ifPresent(this::validateRequestHeaders);
            config.get("validate-response-headers").as(Boolean.class).ifPresent(this::validateResponseHeaders);
            return self();
        }

        /**
         *
         *
         * @param name
         * @return updated builder instance
         * @see #name()
         */
        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return self();
        }

        /**
         * Whether to use keep alive by default.
         *
         * @param defaultKeepAlive {@code true} for keeping connections alive and re-using them for multiple requests (default), {@code false}
         *                         to create a new connection for each request
         * @return updated builder instance
         * @see #defaultKeepAlive()
         */
        public BUILDER defaultKeepAlive(boolean defaultKeepAlive) {
            this.defaultKeepAlive = defaultKeepAlive;
            return self();
        }

        /**
         * Configure the maximum allowed header size of the response.
         *
         * @param maxHeaderSize maximum header size
         * @return updated builder instance
         * @see #maxHeaderSize()
         */
        public BUILDER maxHeaderSize(int maxHeaderSize) {
            this.maxHeaderSize = maxHeaderSize;
            return self();
        }

        /**
         * Configure the maximum allowed length of the status line from the response.
         *
         * @param maxStatusLineLength maximum status line length
         * @return updated builder instance
         * @see #maxStatusLineLength()
         */
        public BUILDER maxStatusLineLength(int maxStatusLineLength) {
            this.maxStatusLineLength = maxStatusLineLength;
            return self();
        }

        /**
         * Sets whether the request header format is validated or not.
         * <p>
         *     Defaults to {@code false} as user has control on the header creation.
         * </p>
         *
         * @param validateRequestHeaders whether request header validation should be enabled
         * @return updated builder instance
         * @see #validateRequestHeaders()
         */
        public BUILDER validateRequestHeaders(boolean validateRequestHeaders) {
            this.validateRequestHeaders = validateRequestHeaders;
            return self();
        }

        /**
         * Sets whether the response header format is validated or not.
         * <p>
         *     Defaults to {@code true}.
         * </p>
         *
         * @param validateResponseHeaders whether response header validation should be enabled
         * @return updated builder instance
         * @see #validateResponseHeaders()
         */
        public BUILDER validateResponseHeaders(boolean validateResponseHeaders) {
            this.validateResponseHeaders = validateResponseHeaders;
            return self();
        }

        /**
         *
         *
         * @return the name
         */
        public String name() {
            return name;
        }

        /**
         * Whether to use keep alive by default.
         *
         * @return the default keep alive
         */
        public boolean defaultKeepAlive() {
            return defaultKeepAlive;
        }

        /**
         * Configure the maximum allowed header size of the response.
         *
         * @return the max header size
         */
        public int maxHeaderSize() {
            return maxHeaderSize;
        }

        /**
         * Configure the maximum allowed length of the status line from the response.
         *
         * @return the max status line length
         */
        public int maxStatusLineLength() {
            return maxStatusLineLength;
        }

        /**
         * Sets whether the request header format is validated or not.
         * <p>
         *     Defaults to {@code false} as user has control on the header creation.
         * </p>
         *
         * @return the validate request headers
         */
        public boolean validateRequestHeaders() {
            return validateRequestHeaders;
        }

        /**
         * Sets whether the response header format is validated or not.
         * <p>
         *     Defaults to {@code true}.
         * </p>
         *
         * @return the validate response headers
         */
        public boolean validateResponseHeaders() {
            return validateResponseHeaders;
        }

        /**
         * If this instance was configured, this would be the config instance used.
         *
         * @return config node used to configure this builder, or empty if not configured
         */
        public Optional<Config> config() {
            return Optional.ofNullable(config);
        }

        @Override
        public String toString() {
            return "Http1ClientProtocolConfigBuilder{"
                    + "name=" + name + ","
                    + "defaultKeepAlive=" + defaultKeepAlive + ","
                    + "maxHeaderSize=" + maxHeaderSize + ","
                    + "maxStatusLineLength=" + maxStatusLineLength + ","
                    + "validateRequestHeaders=" + validateRequestHeaders + ","
                    + "validateResponseHeaders=" + validateResponseHeaders
                    + "}";
        }

        /**
         * Handles providers and decorators.
         */
        protected void preBuildPrototype() {
        }

        /**
         * Validates required properties.
         */
        protected void validatePrototype() {
        }

        /**
         * Generated implementation of the prototype, can be extended by descendant prototype implementations.
         */
        protected static class Http1ClientProtocolConfigImpl implements Http1ClientProtocolConfig {

            private final boolean defaultKeepAlive;
            private final boolean validateRequestHeaders;
            private final boolean validateResponseHeaders;
            private final int maxHeaderSize;
            private final int maxStatusLineLength;
            private final String name;

            /**
             * Create an instance providing a builder.
             *
             * @param builder extending builder base of this prototype
             */
            protected Http1ClientProtocolConfigImpl(Http1ClientProtocolConfig.BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.defaultKeepAlive = builder.defaultKeepAlive();
                this.maxHeaderSize = builder.maxHeaderSize();
                this.maxStatusLineLength = builder.maxStatusLineLength();
                this.validateRequestHeaders = builder.validateRequestHeaders();
                this.validateResponseHeaders = builder.validateResponseHeaders();
            }

            @Override
            public String name() {
                return name;
            }

            @Override
            public boolean defaultKeepAlive() {
                return defaultKeepAlive;
            }

            @Override
            public int maxHeaderSize() {
                return maxHeaderSize;
            }

            @Override
            public int maxStatusLineLength() {
                return maxStatusLineLength;
            }

            @Override
            public boolean validateRequestHeaders() {
                return validateRequestHeaders;
            }

            @Override
            public boolean validateResponseHeaders() {
                return validateResponseHeaders;
            }

            @Override
            public String toString() {
                return "Http1ClientProtocolConfig{"
                        + "name=" + name + ","
                        + "defaultKeepAlive=" + defaultKeepAlive + ","
                        + "maxHeaderSize=" + maxHeaderSize + ","
                        + "maxStatusLineLength=" + maxStatusLineLength + ","
                        + "validateRequestHeaders=" + validateRequestHeaders + ","
                        + "validateResponseHeaders=" + validateResponseHeaders
                        + "}";
            }

            @Override
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Http1ClientProtocolConfig other)) {
                    return false;
                }
                return Objects.equals(name, other.name())
                    && defaultKeepAlive == other.defaultKeepAlive()
                    && maxHeaderSize == other.maxHeaderSize()
                    && maxStatusLineLength == other.maxStatusLineLength()
                    && validateRequestHeaders == other.validateRequestHeaders()
                    && validateResponseHeaders == other.validateResponseHeaders();
            }

            @Override
            public int hashCode() {
                return Objects.hash(name, defaultKeepAlive, maxHeaderSize, maxStatusLineLength, validateRequestHeaders, validateResponseHeaders);
            }

        }

    }

    /**
     * Fluent API builder for {@link Http1ClientProtocolConfig}.
     */
    class Builder extends Http1ClientProtocolConfig.BuilderBase<Http1ClientProtocolConfig.Builder, Http1ClientProtocolConfig> implements io.helidon.common.Builder<Http1ClientProtocolConfig.Builder, Http1ClientProtocolConfig> {

        private Builder() {
        }

        @Override
        public Http1ClientProtocolConfig buildPrototype() {
            preBuildPrototype();
            validatePrototype();
            return new Http1ClientProtocolConfigImpl(this);
        }

        @Override
        public Http1ClientProtocolConfig build() {
            return buildPrototype();
        }

    }

}
