/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.security;

import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.security.EndpointConfig;
import io.helidon.security.OutboundSecurityClientBuilder;
import io.helidon.security.OutboundSecurityResponse;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tracer;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.spi.WebClientService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;

public class WebClientSecurity
implements WebClientService {
    private static final System.Logger LOGGER = System.getLogger(WebClientSecurity.class.getName());
    private static final String PROVIDER_NAME = "io.helidon.security.rest.client.security.providerName";
    private final Security security;

    private WebClientSecurity() {
        this(null);
    }

    private WebClientSecurity(Security security) {
        this.security = security;
    }

    public static WebClientSecurity create() {
        Context context = Contexts.context().orElseGet(Contexts::globalContext);
        return context.get(Security.class).map(WebClientSecurity::new).orElseGet(WebClientSecurity::new);
    }

    public static WebClientSecurity create(Security security) {
        return new WebClientSecurity(security);
    }

    public String type() {
        return "security";
    }

    public WebClientServiceResponse handle(WebClientService.Chain chain, WebClientServiceRequest request) {
        OutboundSecurityClientBuilder clientBuilder;
        Span span;
        SecurityContext context;
        if ("true".equalsIgnoreCase((String)request.properties().get("io.helidon.security.client.disable"))) {
            return chain.proceed(request);
        }
        Context requestContext = request.context();
        Optional maybeContext = requestContext.get(SecurityContext.class);
        if (this.security == null) {
            if (maybeContext.isEmpty()) {
                return chain.proceed(request);
            }
            context = (SecurityContext)maybeContext.get();
        } else {
            context = this.createContext(request);
        }
        Tracer tracer = context.tracer();
        if (tracer == null) {
            span = null;
        } else {
            SpanContext parentSpanContext = context.tracingSpan();
            span = ((Span.Builder)tracer.spanBuilder("security:outbound").update(builder -> {
                if (parentSpanContext != null) {
                    builder.parent(parentSpanContext);
                }
            })).start();
        }
        String explicitProvider = (String)request.properties().get(PROVIDER_NAME);
        try {
            SecurityEnvironment.Builder outboundEnv = context.env().derive().clearHeaders().clearQueryParams();
            outboundEnv.method(request.method().text()).path(request.uri().path().path()).targetUri(request.uri().toUri()).queryParams(request.uri().query());
            request.headers().stream().forEach(headerValue -> outboundEnv.header(headerValue.name(), headerValue.values()));
            EndpointConfig.Builder outboundEp = context.endpointConfig().derive();
            Map propMap = request.properties();
            for (String name : propMap.keySet()) {
                Optional.ofNullable((String)request.properties().get(name)).ifPresent(property -> outboundEp.addAtribute(name, property));
            }
            clientBuilder = (OutboundSecurityClientBuilder)context.outboundClientBuilder().outboundEnvironment((Supplier)outboundEnv).outboundEndpointConfig((Supplier)outboundEp).explicitProvider(explicitProvider);
        }
        catch (Exception e) {
            WebClientSecurity.traceError(span, e, null);
            throw e;
        }
        OutboundSecurityResponse providerResponse = clientBuilder.submit();
        return this.processResponse(request, span, providerResponse, chain);
    }

    private WebClientServiceResponse processResponse(WebClientServiceRequest request, Span span, OutboundSecurityResponse providerResponse, WebClientService.Chain chain) {
        try {
            switch (providerResponse.status()) {
                case FAILURE: 
                case FAILURE_FINISH: {
                    WebClientSecurity.traceError(span, providerResponse.throwable().orElse(null), providerResponse.description().orElse(providerResponse.status().toString()));
                    break;
                }
            }
            Map newHeaders = providerResponse.requestHeaders();
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                LOGGER.log(System.Logger.Level.TRACE, "Client filter header(s). SIZE: " + newHeaders.size());
            }
            ClientRequestHeaders clientHeaders = request.headers();
            for (Map.Entry entry : newHeaders.entrySet()) {
                if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                    LOGGER.log(System.Logger.Level.TRACE, "    + Header: " + (String)entry.getKey() + ": " + String.valueOf(entry.getValue()));
                }
                HeaderName headerName = HeaderNames.create((String)((String)entry.getKey()));
                clientHeaders.set(headerName, ((List)entry.getValue()).toArray(new String[0]));
            }
            if (span != null) {
                span.end();
            }
            return chain.proceed(request);
        }
        catch (Exception e) {
            WebClientSecurity.traceError(span, e, null);
            throw e;
        }
    }

    private SecurityContext createContext(WebClientServiceRequest request) {
        SecurityContext.Builder builder = this.security.contextBuilder(UUID.randomUUID().toString()).endpointConfig(EndpointConfig.builder().build()).env(SecurityEnvironment.builder().path(request.uri().path().path()).build());
        request.context().get(Tracer.class).ifPresent(arg_0 -> ((SecurityContext.Builder)builder).tracingTracer(arg_0));
        request.context().get(SpanContext.class).ifPresent(arg_0 -> ((SecurityContext.Builder)builder).tracingSpan(arg_0));
        return builder.build();
    }

    static void traceError(Span span, Throwable throwable, String description) {
        if (span == null) {
            return;
        }
        span.status(Span.Status.ERROR);
        if (throwable == null) {
            span.addEvent("error", Map.of("message", description, "error.kind", "SecurityException"));
            span.end();
        } else {
            span.end(throwable);
        }
    }
}

