/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.websocket;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.webclient.websocket.WsClientProtocolConfigBlueprint;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webclient.websocket.WsClientProtocolConfigBlueprint")
public interface WsClientProtocolConfig
extends WsClientProtocolConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WsClientProtocolConfig instance) {
        return (Builder)WsClientProtocolConfig.builder().from(instance);
    }

    public static WsClientProtocolConfig create(Config config) {
        return ((Builder)WsClientProtocolConfig.builder().config(config)).buildPrototype();
    }

    public static WsClientProtocolConfig create() {
        return WsClientProtocolConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, WsClientProtocolConfig>
    implements io.helidon.common.Builder<Builder, WsClientProtocolConfig> {
        private Builder() {
        }

        public WsClientProtocolConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.WsClientProtocolConfigImpl(this);
        }

        public WsClientProtocolConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends WsClientProtocolConfig>
    implements Prototype.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<String> subProtocols = new ArrayList<String>();
        private boolean isSubProtocolsMutated;
        private Config config;
        private String name = "websocket";

        protected BuilderBase() {
        }

        public BUILDER from(WsClientProtocolConfig prototype) {
            this.name(prototype.name());
            if (!this.isSubProtocolsMutated) {
                this.subProtocols.clear();
            }
            this.addSubProtocols(prototype.subProtocols());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.name(builder.name());
            if (this.isSubProtocolsMutated) {
                if (builder.isSubProtocolsMutated) {
                    this.addSubProtocols(builder.subProtocols);
                }
            } else {
                this.subProtocols.clear();
                this.addSubProtocols(builder.subProtocols);
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("name").as(String.class).ifPresent(this::name);
            config.get("sub-protocols").asList(String.class).ifPresent(this::subProtocols);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER subProtocols(List<? extends String> subProtocols) {
            Objects.requireNonNull(subProtocols);
            this.isSubProtocolsMutated = true;
            this.subProtocols.clear();
            this.subProtocols.addAll(subProtocols);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSubProtocols(List<? extends String> subProtocols) {
            Objects.requireNonNull(subProtocols);
            this.isSubProtocolsMutated = true;
            this.subProtocols.addAll(subProtocols);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addSubProtocol(String subProtocol) {
            Objects.requireNonNull(subProtocol);
            this.subProtocols.add(subProtocol);
            this.isSubProtocolsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public String name() {
            return this.name;
        }

        public List<String> subProtocols() {
            return this.subProtocols;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "WsClientProtocolConfigBuilder{name=" + this.name + ",subProtocols=" + String.valueOf(this.subProtocols) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class WsClientProtocolConfigImpl
        implements WsClientProtocolConfig {
            private final List<String> subProtocols;
            private final String name;

            protected WsClientProtocolConfigImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name();
                this.subProtocols = List.copyOf(builder.subProtocols());
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public List<String> subProtocols() {
                return this.subProtocols;
            }

            public String toString() {
                return "WsClientProtocolConfig{name=" + this.name + ",subProtocols=" + String.valueOf(this.subProtocols) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WsClientProtocolConfig)) {
                    return false;
                }
                WsClientProtocolConfig other = (WsClientProtocolConfig)o;
                return Objects.equals(this.name, other.name()) && Objects.equals(this.subProtocols, other.subProtocols());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.subProtocols);
            }
        }
    }
}

