/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.config.Config;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

final class OutboundTarget {
    public static final String CONFIG_NAME = "name";
    public static final String CONFIG_TRANSPORTS = "transports";
    public static final String CONFIG_HOSTS = "hosts";
    public static final String CONFIG_PATHS = "paths";
    private final String name;
    private final Set<String> transports = new HashSet<String>();
    private final Set<String> hosts = new HashSet<String>();
    private final List<Pattern> hostPatterns = new LinkedList<Pattern>();
    private final Set<String> paths = new HashSet<String>();
    private final List<Pattern> pathPatterns = new LinkedList<Pattern>();
    private final Config config;
    private final boolean matchAllTransports;
    private final boolean matchAllHosts;
    private final boolean matchAllPaths;

    private OutboundTarget(Builder builder) {
        this.name = builder.name;
        this.transports.addAll(builder.transports);
        this.hosts.addAll(builder.hosts);
        this.paths.addAll(builder.paths);
        this.config = builder.config;
        this.matchAllTransports = this.transports.isEmpty() || this.anyMatch(this.transports);
        this.matchAllHosts = this.hosts.isEmpty() || this.anyMatch(this.hosts);
        boolean bl = this.matchAllPaths = this.paths.isEmpty() || this.anyMatch(this.paths);
        if (!this.matchAllHosts) {
            this.hosts.stream().filter(s -> s.contains("*")).forEach(host -> this.hostPatterns.add(this.toPattern((String)host)));
        }
        if (!this.matchAllPaths) {
            this.paths.forEach(path -> this.pathPatterns.add(Pattern.compile(path)));
        }
    }

    static OutboundTarget create(Config c) {
        Builder builder = new Builder();
        builder.config(c);
        builder.name((String)c.get(CONFIG_NAME).asString().get());
        ((List)c.get(CONFIG_TRANSPORTS).asList(String.class).orElse(List.of())).forEach(builder::addTransport);
        ((List)c.get(CONFIG_HOSTS).asList(String.class).orElse(List.of())).forEach(builder::addHost);
        ((List)c.get(CONFIG_PATHS).asList(String.class).orElse(List.of())).forEach(builder::addPath);
        return builder.build();
    }

    public static Builder builder(String name) {
        return new Builder().name(name);
    }

    private Pattern toPattern(String host) {
        String pattern = host.replaceAll("\\.", "\\.");
        pattern = pattern.replaceAll("\\*", ".*");
        return Pattern.compile(pattern);
    }

    private boolean anyMatch(Set<String> values) {
        return values.contains("*");
    }

    public String name() {
        return this.name;
    }

    public Set<String> transports() {
        return Collections.unmodifiableSet(this.transports);
    }

    public Set<String> hosts() {
        return Collections.unmodifiableSet(this.hosts);
    }

    public Optional<Config> getConfig() {
        return Optional.ofNullable(this.config);
    }

    boolean matches(String transport, String host, String path) {
        return this.matchTransport(transport) && this.matchHost(host) && this.matchPath(path);
    }

    boolean matchPath(String path) {
        return this.match(path, this.matchAllPaths, this.paths, this.pathPatterns);
    }

    private boolean match(String toMatch, boolean matchAll, Set<String> values, List<Pattern> patterns) {
        if (matchAll) {
            return true;
        }
        if (null == toMatch) {
            return false;
        }
        if (values.contains(toMatch)) {
            return true;
        }
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(toMatch).matches()) continue;
            return true;
        }
        return false;
    }

    boolean matchHost(String requestHost) {
        return this.match(requestHost, this.matchAllHosts, this.hosts, this.hostPatterns);
    }

    boolean matchTransport(String requestTransport) {
        if (this.matchAllTransports) {
            return true;
        }
        for (String transport : this.transports) {
            if (!requestTransport.equals(transport)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutboundTarget that = (OutboundTarget)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "TargetConfig{name='" + this.name + "', transports=" + this.transports + ", hosts=" + this.hosts + ", hostPatterns=" + this.hostPatterns + ", config=" + this.config + ", matchAllTransports=" + this.matchAllTransports + ", matchAllHosts=" + this.matchAllHosts + "}";
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, OutboundTarget> {
        private final Set<String> transports = new HashSet<String>();
        private final Set<String> hosts = new HashSet<String>();
        private final Set<String> paths = new HashSet<String>();
        private String name;
        private Config config;

        private Builder() {
        }

        private Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder config(Config config) {
            this.config = config;
            return this;
        }

        public Builder addHost(String host) {
            this.hosts.add(host);
            return this;
        }

        public Builder addTransport(String transport) {
            this.transports.add(transport);
            return this;
        }

        public Builder addPath(String path) {
            this.paths.add(path);
            return this;
        }

        public OutboundTarget build() {
            return new OutboundTarget(this);
        }
    }
}

