/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.context.Context;
import io.helidon.common.http.Http;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.media.common.MediaContext;
import io.helidon.media.common.MediaContextBuilder;
import io.helidon.media.common.MediaSupport;
import io.helidon.media.common.MessageBodyReader;
import io.helidon.media.common.MessageBodyStreamReader;
import io.helidon.media.common.MessageBodyStreamWriter;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.common.ParentingMediaContextBuilder;
import io.helidon.webclient.DnsResolverType;
import io.helidon.webclient.NettyClient;
import io.helidon.webclient.Proxy;
import io.helidon.webclient.WebClientConfiguration;
import io.helidon.webclient.WebClientException;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.WebClientTls;
import io.helidon.webclient.spi.WebClientService;
import io.helidon.webclient.spi.WebClientServiceProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface WebClient {
    public static WebClient create() {
        return WebClient.builder().build();
    }

    public static WebClient create(Config config) {
        return WebClient.builder().config(config).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public WebClientRequestBuilder put();

    public WebClientRequestBuilder get();

    public WebClientRequestBuilder post();

    public WebClientRequestBuilder delete();

    public WebClientRequestBuilder options();

    public WebClientRequestBuilder trace();

    public WebClientRequestBuilder head();

    public WebClientRequestBuilder method(String var1);

    public WebClientRequestBuilder method(Http.RequestMethod var1);

    public static final class Builder
    implements io.helidon.common.Builder<Builder, WebClient>,
    ParentingMediaContextBuilder<Builder>,
    MediaContextBuilder<Builder> {
        private final WebClientConfiguration.Builder<?, ?> configuration = NettyClient.SHARED_CONFIGURATION.derive();
        private final HelidonServiceLoader.Builder<WebClientServiceProvider> services = HelidonServiceLoader.builder(ServiceLoader.load(WebClientServiceProvider.class));
        private final List<WebClientService> webClientServices = new ArrayList<WebClientService>();
        private Config config = Config.empty();

        private Builder() {
        }

        public WebClient build() {
            return new NettyClient(this);
        }

        public Builder addService(WebClientService service) {
            this.webClientServices.add(service);
            return this;
        }

        public Builder addService(Supplier<? extends WebClientService> serviceSupplier) {
            return this.addService(serviceSupplier.get());
        }

        public Builder useSystemServiceLoader(boolean useServiceLoader) {
            this.services.useSystemServiceLoader(useServiceLoader);
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.configuration.proxy(proxy);
            return this;
        }

        public Builder mediaContext(MediaContext mediaContext) {
            this.configuration.mediaContext(mediaContext);
            return this;
        }

        public Builder addMediaSupport(MediaSupport mediaSupport) {
            this.configuration.addMediaSupport(mediaSupport);
            return this;
        }

        public Builder addReader(MessageBodyReader<?> reader) {
            this.configuration.addReader((MessageBodyReader)reader);
            return this;
        }

        public Builder addStreamReader(MessageBodyStreamReader<?> streamReader) {
            this.configuration.addStreamReader((MessageBodyStreamReader)streamReader);
            return this;
        }

        public Builder addWriter(MessageBodyWriter<?> writer) {
            this.configuration.addWriter((MessageBodyWriter)writer);
            return this;
        }

        public Builder addStreamWriter(MessageBodyStreamWriter<?> streamWriter) {
            this.configuration.addStreamWriter((MessageBodyStreamWriter)streamWriter);
            return this;
        }

        public Builder config(Config config) {
            this.config = config;
            this.configuration.config(config);
            return this;
        }

        public Builder connectTimeout(long amount, TimeUnit unit) {
            this.configuration.connectTimeout(Duration.of(amount, unit.toChronoUnit()));
            return this;
        }

        public Builder readTimeout(long amount, TimeUnit unit) {
            this.configuration.readTimeout(Duration.of(amount, unit.toChronoUnit()));
            return this;
        }

        public Builder tls(WebClientTls webClientTls) {
            this.configuration.tls(webClientTls);
            return this;
        }

        public Builder context(Context context) {
            this.configuration.context(context);
            return this;
        }

        public Builder addCookie(String name, String value) {
            this.configuration.defaultCookie(name, value);
            return this;
        }

        public Builder addHeader(String header, String ... value) {
            this.configuration.defaultHeader(header, Arrays.asList(value));
            return this;
        }

        public Builder baseUri(URI uri) {
            this.configuration.uri(uri);
            return this;
        }

        public Builder baseUri(String uri) {
            return this.baseUri(URI.create(uri));
        }

        public Builder baseUri(URL url) {
            try {
                return this.baseUri(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new WebClientException("Failed to create URI from URL", e);
            }
        }

        public Builder followRedirects(boolean follow) {
            this.configuration.followRedirects(follow);
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.configuration.userAgent(userAgent);
            return this;
        }

        public Builder keepAlive(boolean keepAlive) {
            this.configuration.keepAlive(keepAlive);
            return this;
        }

        public Builder validateHeaders(boolean validate) {
            this.configuration.validateHeaders(validate);
            return this;
        }

        public Builder dnsResolverType(DnsResolverType dnsResolverType) {
            this.configuration.dnsResolverType(dnsResolverType);
            return this;
        }

        WebClientConfiguration configuration() {
            this.configuration.clientServices(this.services());
            return this.configuration.build();
        }

        private List<WebClientService> services() {
            Config servicesConfig = this.config.get("services");
            this.services.build().asList().forEach(provider -> {
                Config providerConfig = servicesConfig.get(provider.configKey());
                if (providerConfig.exists()) {
                    this.addService(provider.create(providerConfig));
                }
            });
            return this.webClientServices;
        }
    }
}

