/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.jersey;

import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import io.helidon.webserver.jersey.ResponseWriter;
import io.helidon.webserver.jersey.WebServerBinder;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

public class JerseySupport
implements Service {
    @Deprecated
    public static final String REQUEST_SPAN_QUALIFIER = "request-parent-span";
    public static final String REQUEST_SPAN_CONTEXT = "request-span-context";
    private static final Logger LOGGER = Logger.getLogger(JerseySupport.class.getName());
    private final Type requestType = new GenericType<Ref<ServerRequest>>(){}.getType();
    private final Type responseType = new GenericType<Ref<ServerResponse>>(){}.getType();
    private final Type spanType = new GenericType<Ref<Span>>(){}.getType();
    private final Type spanContextType = new GenericType<Ref<SpanContext>>(){}.getType();
    private final ApplicationHandler appHandler;
    private final ExecutorService service;
    private final JerseyHandler handler = new JerseyHandler();

    private JerseySupport(Application application, ExecutorService service) {
        this.appHandler = new ApplicationHandler(application, (Binder)new WebServerBinder());
        this.service = service != null ? service : Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
    }

    public void update(Routing.Rules routingRules) {
        routingRules.any(new Handler[]{this.handler});
    }

    private static URI requestUri(ServerRequest req) {
        try {
            URI partialUri = new URI(req.isSecure() ? "https" : "http", null, req.localAddress(), req.localPort(), req.path().absolute().toString(), null, null);
            StringBuilder sb = new StringBuilder(partialUri.toString());
            if (req.uri().toString().endsWith("/") && sb.charAt(sb.length() - 1) != '/') {
                sb.append('/');
            }
            if (req.query() != null && !req.query().isEmpty()) {
                sb.append("?").append(req.query());
            }
            if (req.fragment() != null && !req.fragment().isEmpty()) {
                sb.append("#").append(req.fragment());
            }
            return new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unable to create a request URI from the request info.", e);
        }
    }

    private static URI baseUri(ServerRequest req) {
        try {
            return new URI(req.isSecure() ? "https" : "http", null, req.localAddress(), req.localPort(), JerseySupport.basePath(req), null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unable to create a base URI from the request info.", e);
        }
    }

    private static String basePath(ServerRequest req) {
        String reqPath = req.path().toString();
        String absPath = req.path().absolute().toString();
        String basePath = absPath.substring(0, absPath.length() - reqPath.length());
        if (absPath.isEmpty() || basePath.isEmpty()) {
            return "/";
        }
        if (basePath.charAt(basePath.length() - 1) != '/') {
            return basePath + "/";
        }
        return basePath;
    }

    public static JerseySupport create(Application application) {
        return JerseySupport.builder(application).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Application application) {
        return new Builder(application);
    }

    public static class Builder
    implements Configurable<Builder>,
    io.helidon.common.Builder {
        private ResourceConfig resourceConfig;
        private ExecutorService executorService;

        private Builder() {
            this((Application)null);
        }

        private Builder(Application application) {
            if (application == null) {
                application = new Application();
            }
            this.resourceConfig = ResourceConfig.forApplication((Application)application);
        }

        public JerseySupport build() {
            return new JerseySupport((Application)this.resourceConfig, this.executorService);
        }

        public Configuration getConfiguration() {
            return this.resourceConfig.getConfiguration();
        }

        public Builder property(String key, Object value) {
            this.resourceConfig.property(key, value);
            return this;
        }

        public Builder register(Class<?> componentClass) {
            this.resourceConfig.register(componentClass);
            return this;
        }

        public Builder register(Class<?> componentClass, int priority) {
            this.resourceConfig.register(componentClass, priority);
            return this;
        }

        public Builder register(Class<?> componentClass, Class<?> ... contracts) {
            this.resourceConfig.register(componentClass, (Class[])contracts);
            return this;
        }

        public Builder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
            this.resourceConfig.register(componentClass, contracts);
            return this;
        }

        public Builder register(Object component) {
            this.resourceConfig.register(component);
            return this;
        }

        public Builder register(Object component, int priority) {
            this.resourceConfig.register(component, priority);
            return this;
        }

        public Builder register(Object component, Class<?> ... contracts) {
            this.resourceConfig.register(component, (Class[])contracts);
            return this;
        }

        public Builder register(Object component, Map<Class<?>, Integer> contracts) {
            this.resourceConfig.register(component, contracts);
            return this;
        }

        public Builder registerResources(Resource ... resources) {
            this.resourceConfig.registerResources(resources);
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }
    }

    private static class WebServerSecurityContext
    implements SecurityContext {
        private WebServerSecurityContext() {
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    }

    private static class WebServerPropertiesDelegate
    implements PropertiesDelegate {
        private final ServerRequest req;

        WebServerPropertiesDelegate(ServerRequest req) {
            this.req = req;
        }

        public Object getProperty(String name) {
            return this.req.context().get((Object)name, Object.class).orElse(null);
        }

        public Collection<String> getPropertyNames() {
            throw new UnsupportedOperationException("iteration over property names not allowed");
        }

        public void setProperty(String name, Object object) {
            this.req.context().register((Object)name, object);
        }

        public void removeProperty(String name) {
            throw new UnsupportedOperationException("property removal from the context is not allowed");
        }
    }

    private class JerseyHandler
    implements Handler {
        private JerseyHandler() {
        }

        public void accept(ServerRequest req, ServerResponse res) {
            CompletableFuture<Void> whenHandleFinishes = new CompletableFuture<Void>();
            ResponseWriter responseWriter = new ResponseWriter(res, req, whenHandleFinishes);
            ContainerRequest requestContext = new ContainerRequest(JerseySupport.baseUri(req), JerseySupport.requestUri(req), req.method().name(), (SecurityContext)new WebServerSecurityContext(), (PropertiesDelegate)new WebServerPropertiesDelegate(req));
            req.headers().toMap().forEach((arg_0, arg_1) -> ((ContainerRequest)requestContext).headers(arg_0, arg_1));
            requestContext.setWriter((ContainerResponseWriter)responseWriter);
            req.content().as(InputStream.class).thenAccept(is -> {
                requestContext.setEntityStream(is);
                JerseySupport.this.service.submit(() -> {
                    try {
                        LOGGER.finer("Handling in Jersey started.");
                        requestContext.setRequestScopedInitializer(injectionManager -> {
                            ((Ref)injectionManager.getInstance(JerseySupport.this.requestType)).set((Object)req);
                            ((Ref)injectionManager.getInstance(JerseySupport.this.responseType)).set((Object)res);
                            ((Ref)injectionManager.getInstance(JerseySupport.this.spanType)).set((Object)req.span());
                            ((Ref)injectionManager.getInstance(JerseySupport.this.spanContextType)).set((Object)req.spanContext());
                        });
                        JerseySupport.this.appHandler.handle(requestContext);
                        whenHandleFinishes.complete(null);
                    }
                    catch (Throwable e) {
                        req.next(e);
                    }
                });
            }).exceptionally(throwable -> {
                req.next(throwable);
                return null;
            });
        }
    }
}

