/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.jersey;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.OutputStreamPublisher;
import io.helidon.webserver.ConnectionClosedException;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

class ResponseWriter
implements ContainerResponseWriter {
    private static final Logger LOGGER = Logger.getLogger(ResponseWriter.class.getName());
    private final OutputStreamPublisher publisher = new OutputStreamPublisher(){

        public void write(byte[] b) throws IOException {
            try {
                super.write(b);
            }
            catch (ConnectionClosedException e) {
                throw new IOException("Cannot publish more bytes due to a connection close.", e);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                super.write(b, off, len);
            }
            catch (ConnectionClosedException e) {
                throw new IOException("Cannot publish more bytes due to a connection close.", e);
            }
        }

        public void write(int b) throws IOException {
            try {
                super.write(b);
            }
            catch (ConnectionClosedException e) {
                throw new IOException("Cannot publish more bytes due to a connection close.", e);
            }
        }

        public void close() throws IOException {
            try {
                super.signalCloseComplete(null);
                super.close();
            }
            catch (ConnectionClosedException e) {
                throw new IOException("Cannot close the connection because it's already closed.", e);
            }
        }

        public void flush() throws IOException {
            try {
                super.flush();
            }
            catch (ConnectionClosedException e) {
                throw new IOException("Cannot flush on the connection because it's closed.", e);
            }
        }
    };
    private final ServerResponse res;
    private final ServerRequest req;
    private final CompletableFuture<Void> whenHandleFinishes;

    ResponseWriter(ServerResponse res, ServerRequest req, CompletableFuture<Void> whenHandleFinishes) {
        this.res = res;
        this.req = req;
        this.whenHandleFinishes = whenHandleFinishes;
    }

    public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse context) throws ContainerException {
        if (context.getStatus() == 404 && contentLength == 0L) {
            this.whenHandleFinishes.thenRun(() -> {
                LOGGER.finer("Skipping the handling and forwarding to downstream WebServer filters.");
                this.req.next();
            });
            return new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            };
        }
        this.res.status(Http.ResponseStatus.create((int)context.getStatus(), (String)context.getStatusInfo().getReasonPhrase()));
        if (contentLength >= 0L) {
            this.res.headers().put("Content-Length", new String[]{String.valueOf(contentLength)});
        }
        for (Map.Entry entry : context.getStringHeaders().entrySet()) {
            this.res.headers().put((String)entry.getKey(), (Iterable)entry.getValue());
        }
        this.res.send((Flow.Publisher)Multi.from((Flow.Publisher)this.publisher).map(byteBuffer -> DataChunk.create((boolean)ResponseWriter.doFlush(context, byteBuffer), (ByteBuffer)byteBuffer, (boolean)true)));
        return this.publisher;
    }

    public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
        if (timeOut != 0L) {
            throw new UnsupportedOperationException("Currently, time limited suspension is not supported!");
        }
        return true;
    }

    public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
        throw new UnsupportedOperationException("Currently, extending the suspension time is not supported!");
    }

    public void commit() {
        try {
            this.publisher.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO Exception received!", e);
        }
    }

    public void failure(Throwable error) {
        LOGGER.finer(() -> "Jersey handling finished with an exception; message: " + error.getMessage());
        this.req.next(error);
    }

    public boolean enableResponseBuffering() {
        return false;
    }

    private static boolean doFlush(ContainerResponse context, ByteBuffer byteBuffer) {
        return MediaType.SERVER_SENT_EVENTS_TYPE.isCompatible(context.getMediaType()) || byteBuffer.hasArray() && byteBuffer.array().length == 0;
    }
}

