/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.jersey;

import io.helidon.common.configurable.ServerThreadPoolSupplier;
import io.helidon.common.configurable.ThreadPool;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.webserver.Handler;
import io.helidon.webserver.HttpException;
import io.helidon.webserver.KeyPerformanceIndicatorSupport;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.jersey.AsyncExecutorProvider;
import io.helidon.webserver.jersey.HelidonHK2InjectionManagerFactory;
import io.helidon.webserver.jersey.ResponseWriter;
import io.helidon.webserver.jersey.WebServerBinder;
import io.opentracing.SpanContext;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

public class JerseySupport
implements Service {
    private static final String SEC_WEBSOCKET_KEY = "Sec-WebSocket-Key";
    public static final String REQUEST_SPAN_CONTEXT = "request-span-context";
    private static final Logger LOGGER = Logger.getLogger(JerseySupport.class.getName());
    private static final Type REQUEST_TYPE = new GenericType<Ref<ServerRequest>>(){}.getType();
    private static final Type RESPONSE_TYPE = new GenericType<Ref<ServerResponse>>(){}.getType();
    private static final Type SPAN_CONTEXT_TYPE = new GenericType<Ref<SpanContext>>(){}.getType();
    private static final AtomicReference<ExecutorService> DEFAULT_THREAD_POOL = new AtomicReference();
    private static final Set<InjectionManager> INJECTION_MANAGERS = Collections.newSetFromMap(new WeakHashMap());
    private final ApplicationHandler appHandler;
    private final ExecutorService service;
    private final JerseyHandler handler;
    private final HelidonJerseyContainer container;
    private final Thread serviceShutdownHook;
    static final String IGNORE_EXCEPTION_RESPONSE = "jersey.config.client.ignoreExceptionResponse";

    private JerseySupport(Builder builder) {
        ExecutorService executorService = builder.executorService != null ? builder.executorService : JerseySupport.getDefaultThreadPool(builder.config);
        this.service = Contexts.wrap((ExecutorService)executorService);
        this.serviceShutdownHook = new Thread(this.service::shutdownNow);
        Runtime.getRuntime().addShutdownHook(this.serviceShutdownHook);
        if (builder.asyncExecutorService == null) {
            builder.resourceConfig.register((Object)AsyncExecutorProvider.create(builder.config));
        } else {
            builder.resourceConfig.register((Object)AsyncExecutorProvider.create(builder.asyncExecutorService));
        }
        this.handler = new JerseyHandler(builder.resourceConfig);
        this.appHandler = new ApplicationHandler((Application)builder.resourceConfig, (Binder)new ServerBinder(executorService), (Object)(builder.injectionManager == null ? null : new HelidonHK2InjectionManagerFactory.InjectionManagerWrapper(builder.injectionManager, builder.resourceConfig)));
        this.container = new HelidonJerseyContainer(this.appHandler, builder.resourceConfig);
        if (!System.getProperties().contains(IGNORE_EXCEPTION_RESPONSE)) {
            System.setProperty("jersey.config.allowSystemPropertiesProvider", "true");
            ConfigValue ignore = builder.config.get(IGNORE_EXCEPTION_RESPONSE).asString();
            System.setProperty(IGNORE_EXCEPTION_RESPONSE, (String)ignore.orElse((Object)"true"));
        }
    }

    public void update(Routing.Rules routingRules) {
        routingRules.any(new Handler[]{this.handler});
        this.appHandler.onStartup((Container)this.container);
        INJECTION_MANAGERS.add(this.appHandler.getInjectionManager());
    }

    Thread serviceShutdownHook() {
        return this.serviceShutdownHook;
    }

    private static synchronized ExecutorService getDefaultThreadPool(Config config) {
        if (DEFAULT_THREAD_POOL.get() == null) {
            Config executorConfig = config.get("executor-service");
            DEFAULT_THREAD_POOL.set(ServerThreadPoolSupplier.builder().name("server").config(executorConfig).build().get());
        }
        return DEFAULT_THREAD_POOL.get();
    }

    private static URI baseUri(ServerRequest req) {
        try {
            return new URI(req.isSecure() ? "https" : "http", null, req.localAddress(), req.localPort(), JerseySupport.basePath(req.path()), null, null);
        }
        catch (URISyntaxException e) {
            throw new HttpException("Unable to parse request URL", (Http.ResponseStatus)Http.Status.BAD_REQUEST_400, (Throwable)e);
        }
    }

    static String basePath(HttpRequest.Path path) {
        String reqPath = path.toString();
        String absPath = path.absolute().toString();
        String basePath = absPath.substring(0, absPath.length() - reqPath.length() + 1);
        if (absPath.isEmpty() || basePath.isEmpty()) {
            return "/";
        }
        if (basePath.charAt(basePath.length() - 1) != '/') {
            return basePath + "/";
        }
        return basePath;
    }

    public void close() {
        try {
            InjectionManager injectionManager = this.appHandler.getInjectionManager();
            if (INJECTION_MANAGERS.remove(injectionManager)) {
                this.appHandler.onShutdown((Container)this.container);
            }
        }
        catch (IllegalStateException e) {
            LOGGER.log(Level.FINEST, e, () -> "Exception during shutdown of Jersey");
            LOGGER.warning(() -> "Exception while shutting down Jersey's application handler " + e.getMessage());
        }
    }

    private static Application getApplication(ResourceConfig resourceConfig) {
        Application wrappedApplication;
        ResourceConfig application = resourceConfig;
        while (application instanceof ResourceConfig && (wrappedApplication = application.getApplication()) != application) {
            application = wrappedApplication;
        }
        return application;
    }

    public static JerseySupport create(Application application) {
        return JerseySupport.builder(application).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Application application) {
        return new Builder(application);
    }

    private static class HelidonJerseyContainer
    implements Container {
        private final ApplicationHandler applicationHandler;

        private HelidonJerseyContainer(ApplicationHandler appHandler, ResourceConfig resourceConfig) {
            this.applicationHandler = appHandler;
        }

        public ResourceConfig getConfiguration() {
            return this.applicationHandler.getConfiguration();
        }

        public ApplicationHandler getApplicationHandler() {
            return this.applicationHandler;
        }

        public void reload() {
            throw new UnsupportedOperationException("Reloading is not supported in Helidon");
        }

        public void reload(ResourceConfig configuration) {
            throw new UnsupportedOperationException("Reloading is not supported in Helidon");
        }
    }

    public static final class Builder
    implements Configurable<Builder>,
    io.helidon.common.Builder<JerseySupport> {
        private ResourceConfig resourceConfig;
        private ExecutorService executorService;
        private Config config = Config.empty();
        private ExecutorService asyncExecutorService;
        private InjectionManager injectionManager;

        private Builder() {
            this(null);
        }

        private Builder(Application application) {
            if (application == null) {
                application = new Application();
            }
            this.resourceConfig = ResourceConfig.forApplication((Application)application);
            Object property = this.resourceConfig.getProperty("jersey.config.disableDefaultProvider");
            if (null == property) {
                LOGGER.fine("Disabling all Jersey default providers (DOM, SAX, Rendered Image, XML Source, and XML Stream Source). You can enabled them by setting system property jersey.config.disableDefaultProvider to NONE");
                this.resourceConfig.property("jersey.config.disableDefaultProvider", (Object)"ALL");
            } else if ("NONE".equals(property)) {
                this.resourceConfig.property("jersey.config.disableDefaultProvider", null);
            }
            if (null == this.resourceConfig.getProperty("jersey.config.server.wadl.disableWadl")) {
                LOGGER.fine("Disabling Jersey WADL feature, you can enable it by setting system property jersey.config.server.wadl.disableWadl to false");
                this.resourceConfig.property("jersey.config.server.wadl.disableWadl", (Object)"true");
            }
        }

        public JerseySupport build() {
            return new JerseySupport(this);
        }

        public Configuration getConfiguration() {
            return this.resourceConfig.getConfiguration();
        }

        public Builder property(String key, Object value) {
            this.resourceConfig.property(key, value);
            return this;
        }

        public Builder register(Class<?> componentClass) {
            this.resourceConfig.register(componentClass);
            return this;
        }

        public Builder register(Class<?> componentClass, int priority) {
            this.resourceConfig.register(componentClass, priority);
            return this;
        }

        public Builder register(Class<?> componentClass, Class<?> ... contracts) {
            this.resourceConfig.register(componentClass, (Class[])contracts);
            return this;
        }

        public Builder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
            this.resourceConfig.register(componentClass, contracts);
            return this;
        }

        public Builder register(Object component) {
            this.resourceConfig.register(component);
            return this;
        }

        public Builder register(Object component, int priority) {
            this.resourceConfig.register(component, priority);
            return this;
        }

        public Builder register(Object component, Class<?> ... contracts) {
            this.resourceConfig.register(component, (Class[])contracts);
            return this;
        }

        public Builder register(Object component, Map<Class<?>, Integer> contracts) {
            this.resourceConfig.register(component, contracts);
            return this;
        }

        public Builder registerResources(Resource ... resources) {
            this.resourceConfig.registerResources(resources);
            return this;
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder asyncExecutorService(ExecutorService executorService) {
            this.asyncExecutorService = executorService;
            return this;
        }

        public Builder config(Config config) {
            this.config = config;
            return this;
        }

        public Builder injectionManager(InjectionManager injectionManager) {
            this.injectionManager = injectionManager;
            return this;
        }
    }

    private static class WebServerSecurityContext
    implements SecurityContext {
        private WebServerSecurityContext() {
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    }

    private class JerseyHandler
    implements Handler {
        private final ResourceConfig resourceConfig;

        JerseyHandler(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
        }

        public void accept(ServerRequest req, ServerResponse res) {
            Optional secWebSocketKey = req.headers().value(JerseySupport.SEC_WEBSOCKET_KEY);
            if (secWebSocketKey.isPresent()) {
                req.next();
                return;
            }
            Context parent = (Context)Contexts.context().orElseThrow(() -> new IllegalStateException("Context must be propagated from server"));
            Context jerseyContext = Context.create((Context)parent);
            Contexts.runInContext((Context)jerseyContext, () -> this.doAccept(req, res));
        }

        private void doAccept(ServerRequest req, ServerResponse res) {
            CompletableFuture<Void> whenHandleFinishes = new CompletableFuture<Void>();
            ContainerRequest requestContext = new ContainerRequest(JerseySupport.baseUri(req), req.absoluteUri(), req.method().name(), (SecurityContext)new WebServerSecurityContext(), (PropertiesDelegate)new MapPropertiesDelegate(), (Configuration)this.resourceConfig);
            ResponseWriter responseWriter = new ResponseWriter(requestContext, res, req, whenHandleFinishes);
            req.headers().toMap().forEach((arg_0, arg_1) -> ((ContainerRequest)requestContext).headers(arg_0, arg_1));
            String remoteHost = req.remoteAddress();
            int remotePort = req.remotePort();
            requestContext.setProperty("io.helidon.jaxrs.remote-host", (Object)remoteHost);
            requestContext.setProperty("io.helidon.jaxrs.remote-port", (Object)remotePort);
            requestContext.setWriter((ContainerResponseWriter)responseWriter);
            Optional kpiMetricsContext = req.context().get(KeyPerformanceIndicatorSupport.DeferrableRequestContext.class);
            req.content().as(InputStream.class).thenAccept(is -> {
                requestContext.setEntityStream(is);
                JerseySupport.this.service.execute(() -> {
                    try {
                        if (LOGGER.isLoggable(Level.FINER)) {
                            LOGGER.finer("Handling in Jersey started for connection: " + Contexts.context().flatMap(ctx -> ctx.get((Object)(WebServer.class.getName() + ".connection"), String.class)).orElse("Unknown"));
                        }
                        req.context().register((Object)JerseySupport.getApplication(this.resourceConfig));
                        kpiMetricsContext.ifPresent(KeyPerformanceIndicatorSupport.DeferrableRequestContext::requestProcessingStarted);
                        requestContext.setRequestScopedInitializer(injectionManager -> {
                            ((Ref)injectionManager.getInstance(REQUEST_TYPE)).set((Object)req);
                            ((Ref)injectionManager.getInstance(RESPONSE_TYPE)).set((Object)res);
                            ((Ref)injectionManager.getInstance(SPAN_CONTEXT_TYPE)).set((Object)req.spanContext().orElse(null));
                        });
                        JerseySupport.this.appHandler.handle(requestContext);
                        whenHandleFinishes.complete(null);
                    }
                    catch (Throwable e) {
                        req.next(e);
                    }
                });
            }).exceptionally(throwable -> {
                req.next(throwable);
                return null;
            });
        }
    }

    private static class ServerBinder
    extends WebServerBinder {
        private final ExecutorService executorService;

        ServerBinder(ExecutorService executorService) {
            this.executorService = Objects.requireNonNull(executorService);
        }

        @Override
        protected void configure() {
            super.configure();
            Optional maybePool = ThreadPool.asThreadPool((ExecutorService)this.executorService);
            if (maybePool.isPresent()) {
                ThreadPool pool = (ThreadPool)maybePool.get();
                ((InstanceBinding)this.bind(pool).named(pool.getName())).to(ThreadPool.class);
            }
        }
    }
}

