/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.jersey;

import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Http;
import io.helidon.webserver.ByteBufDataChunk;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

class ResponseWriter
implements ContainerResponseWriter {
    private static final Logger LOGGER = Logger.getLogger(ResponseWriter.class.getName());
    private final ContainerRequest requestContext;
    private final ServerResponse res;
    private final ServerRequest req;
    private final CompletableFuture<Void> whenHandleFinishes;
    private DataChunkOutputStream publisher;

    ResponseWriter(ContainerRequest requestContext, ServerResponse res, ServerRequest req, CompletableFuture<Void> whenHandleFinishes) {
        this.requestContext = requestContext;
        this.res = res;
        this.req = req;
        this.whenHandleFinishes = whenHandleFinishes;
    }

    public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse context) throws ContainerException {
        for (Map.Entry entry : context.getStringHeaders().entrySet()) {
            this.res.headers().put((String)entry.getKey(), (Iterable)entry.getValue());
        }
        if (context.getStatus() == 404 && contentLength == 0L && this.requestContext.getUriInfo().getMatchedModelResource() == null) {
            this.whenHandleFinishes.thenRun(() -> {
                LOGGER.finer("Skipping the handling and forwarding to downstream WebServer filters.");
                this.req.next();
            });
            return new OutputStream(){

                @Override
                public void write(int b) {
                }
            };
        }
        this.res.status(Http.ResponseStatus.create((int)context.getStatus(), (String)context.getStatusInfo().getReasonPhrase()));
        if (contentLength >= 0L) {
            this.res.headers().put("Content-Length", new String[]{String.valueOf(contentLength)});
        }
        this.publisher = new DataChunkOutputStream();
        this.publisher.autoFlush(MediaType.SERVER_SENT_EVENTS_TYPE.isCompatible(context.getMediaType()));
        this.res.send((Flow.Publisher)this.publisher);
        return this.publisher;
    }

    public boolean suspend(long timeOut, TimeUnit timeUnit, ContainerResponseWriter.TimeoutHandler timeoutHandler) {
        if (timeOut != 0L) {
            throw new UnsupportedOperationException("Currently, time limited suspension is not supported!");
        }
        return true;
    }

    public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
        throw new UnsupportedOperationException("Currently, extending the suspension time is not supported!");
    }

    public void commit() {
        try {
            if (this.publisher != null) {
                this.publisher.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IO Exception received!", e);
        }
    }

    public void failure(Throwable error) {
        LOGGER.finer(() -> "Jersey handling finished with an exception; message: " + error.getMessage());
        this.req.next(error);
    }

    public boolean enableResponseBuffering() {
        return false;
    }

    private static class DataChunkOutputStream
    extends OutputStream
    implements Flow.Publisher<DataChunk>,
    Flow.Subscription {
        private static final int BYTEBUF_DEFAULT_SIZE = 4096;
        private static final long CANCEL = Long.MIN_VALUE;
        private static final long ERROR = -9223372036854775807L;
        private static final long WAIT = -1L;
        private byte[] oneByteArray;
        private ByteBuf byteBuf;
        private ByteBuf byteBufRef;
        private boolean autoFlush;
        private volatile Flow.Subscriber<? super DataChunk> downstream;
        private volatile Semaphore sema;
        private final AtomicLong requested = new AtomicLong();

        private DataChunkOutputStream() {
        }

        public void autoFlush(boolean autoFlush) {
            this.autoFlush = autoFlush;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.oneByteArray == null) {
                this.oneByteArray = new byte[1];
            }
            this.oneByteArray[0] = (byte)b;
            this.write(this.oneByteArray, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            while (len > 0) {
                if (this.byteBuf == null) {
                    this.awaitRequest();
                    this.byteBufRef = this.byteBuf = PooledByteBufAllocator.DEFAULT.buffer(4096);
                }
                int rem = Math.min(this.byteBuf.writableBytes(), len);
                this.byteBuf.writeBytes(b, off, rem);
                off += rem;
                len -= rem;
                if (this.byteBuf.writableBytes() != 0) continue;
                this.publish(this.autoFlush, this.byteBuf);
                this.byteBuf = null;
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.byteBuf == null) {
                this.awaitRequest();
                this.publish(true, Unpooled.EMPTY_BUFFER);
            } else {
                this.byteBuf = null;
                this.publish(true, this.byteBufRef);
                this.byteBufRef = null;
            }
        }

        @Override
        public void close() throws IOException {
            long r;
            if (this.byteBuf != null) {
                this.flush();
            }
            if ((r = this.error()) == Long.MIN_VALUE) {
                return;
            }
            this.requested.set(Long.MIN_VALUE);
            this.awaitDownstream();
            this.downstream.onComplete();
        }

        @Override
        public void subscribe(Flow.Subscriber<? super DataChunk> sub) {
            sub.onSubscribe(this);
            this.downstream = sub;
            if (this.sema != null) {
                this.sema.release();
            }
        }

        @Override
        public void cancel() {
            long r = this.requested.getAndSet(Long.MIN_VALUE);
            if (r == -1L) {
                this.sema.release();
            }
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                long req = this.requested.getAndUpdate(r -> r != Long.MIN_VALUE ? -9223372036854775807L : r);
                if (req == -1L) {
                    this.sema.release();
                }
                return;
            }
            long req = this.requested.getAndUpdate(r -> r == -1L ? n - 1L : (r < 0L ? r : (Long.MAX_VALUE - n > r ? r + n : Long.MAX_VALUE)));
            if (req == -1L) {
                this.sema.release();
            }
        }

        private void publish(boolean doFlush, ByteBuf buf) {
            ByteBufDataChunk d = ByteBufDataChunk.create((boolean)doFlush, (boolean)true, () -> ((ByteBuf)buf).release(), (ByteBuf[])new ByteBuf[]{buf});
            if (this.requested.get() >= 0L) {
                this.awaitDownstream();
                this.downstream.onNext((DataChunk)d);
            } else {
                d.release();
                this.error();
            }
        }

        private long error() {
            long r = this.requested.get();
            if (r == -9223372036854775807L && (r = this.requested.getAndSet(Long.MIN_VALUE)) == -9223372036854775807L) {
                r = Long.MIN_VALUE;
                this.awaitDownstream();
                this.downstream.onError(new IllegalArgumentException("Bad request is not allowed"));
            }
            return r;
        }

        private void awaitDownstream() {
            if (this.downstream == null) {
                Semaphore tmp;
                this.sema = tmp = new Semaphore(0);
                if (this.downstream == null) {
                    tmp.acquireUninterruptibly();
                }
            }
        }

        private void awaitRequest() throws IOException {
            if (this.requested.get() == 0L && this.sema == null) {
                Semaphore tmp;
                this.sema = tmp = new Semaphore(0);
            }
            long req = this.requested.updateAndGet(r -> r + 1L > 0L ? r - 1L : r);
            while (req == -1L) {
                this.sema.acquireUninterruptibly();
                req = this.requested.get();
            }
            if (req == -9223372036854775807L) {
                this.error();
                req = Long.MIN_VALUE;
            }
            if (req == Long.MIN_VALUE) {
                throw new IOException("Bad news: the stream has been closed");
            }
        }
    }
}

