/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.netty;

import io.helidon.webserver.netty.ByteBufRequestChunk;
import io.helidon.webserver.netty.OriginThreadPublisher;
import io.helidon.webserver.netty.ReferenceHoldingQueue;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;

class HttpRequestScopedPublisher
extends OriginThreadPublisher {
    private static final Logger LOGGER = Logger.getLogger(HttpRequestScopedPublisher.class.getName());
    private volatile boolean suspended = false;
    private final ChannelHandlerContext ctx;
    private final ReentrantReadWriteLock.WriteLock lock = new ReentrantReadWriteLock().writeLock();

    HttpRequestScopedPublisher(ChannelHandlerContext ctx, ReferenceHoldingQueue<ByteBufRequestChunk> referenceQueue) {
        super(referenceQueue);
        this.ctx = ctx;
    }

    @Override
    void hookOnCancel() {
        this.ctx.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void hookOnRequested(long n, long result) {
        if (result == Long.MAX_VALUE) {
            LOGGER.finest("Netty autoread: true");
            this.ctx.channel().config().setAutoRead(true);
        } else {
            LOGGER.finest("Netty autoread: false");
            this.ctx.channel().config().setAutoRead(false);
        }
        try {
            this.lock.lock();
            if (this.suspended && super.tryAcquire() > 0L) {
                this.suspended = false;
                LOGGER.finest("Requesting next chunks from Netty.");
                this.ctx.channel().read();
            } else {
                LOGGER.finest("No hook action required.");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long tryAcquire() {
        try {
            this.lock.lock();
            long l = super.tryAcquire();
            if (l <= 0L) {
                this.suspended = true;
            }
            long l2 = l;
            return l2;
        }
        finally {
            this.lock.unlock();
        }
    }
}

