/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.security;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.config.Config;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.uri.UriQuery;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Method;
import io.helidon.http.RoutedPath;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.http.Status;
import io.helidon.security.AuditEvent;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.AuthorizationResponse;
import io.helidon.security.ClassToInstanceStore;
import io.helidon.security.QueryParamMapping;
import io.helidon.security.SecurityClientBuilder;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityRequest;
import io.helidon.security.SecurityRequestBuilder;
import io.helidon.security.SecurityResponse;
import io.helidon.security.Subject;
import io.helidon.security.integration.common.AtnTracing;
import io.helidon.security.integration.common.AtzTracing;
import io.helidon.security.integration.common.SecurityTracing;
import io.helidon.security.internal.SecurityAuditEvent;
import io.helidon.security.util.TokenHandler;
import io.helidon.tracing.SpanContext;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.security.SecurityHandlerConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=SecurityHandlerConfig.class)
public final class SecurityHandler
implements Handler,
RuntimeType.Api<SecurityHandlerConfig> {
    static final String DEFAULT_AUDIT_EVENT_TYPE = "request";
    static final String DEFAULT_AUDIT_MESSAGE_FORMAT = "%3$s %1$s \"%2$s\" %5$s %6$s requested by %4$s";
    private static final System.Logger LOGGER = System.getLogger(SecurityHandler.class.getName());
    private static final SecurityHandler DEFAULT_INSTANCE = SecurityHandler.builder().build();
    private final SecurityHandlerConfig config;
    private final Optional<Set<String>> rolesAllowed;
    private final Optional<ClassToInstanceStore<Object>> customObjects;
    private final Optional<String> explicitAuthenticator;
    private final Optional<String> explicitAuthorizer;
    private final Optional<Boolean> authenticate;
    private final Optional<Boolean> authenticationOptional;
    private final Optional<Boolean> authorize;
    private final Optional<Boolean> audited;
    private final Optional<String> auditEventType;
    private final Optional<String> auditMessageFormat;
    private final List<QueryParamHandler> queryParamHandlers = new LinkedList<QueryParamHandler>();
    private final boolean combined;
    private final Map<String, Config> configMap = new HashMap<String, Config>();
    private final AtomicReference<SecurityHandler> combinedHandler = new AtomicReference();

    private SecurityHandler(SecurityHandlerConfig config) {
        this.config = config;
        Set<String> rolesAllowedSet = config.rolesAllowed();
        this.rolesAllowed = rolesAllowedSet.isEmpty() ? Optional.empty() : Optional.of(rolesAllowedSet);
        this.customObjects = config.customObjects().map(it -> {
            ClassToInstanceStore ctis = new ClassToInstanceStore();
            ctis.putAll(it);
            return ctis;
        });
        this.explicitAuthenticator = config.authenticator();
        this.explicitAuthorizer = config.authorizer();
        this.authenticate = config.authenticate();
        this.authenticationOptional = config.authenticationOptional();
        this.audited = config.audit();
        this.auditEventType = config.auditEventType();
        this.auditMessageFormat = config.auditMessageFormat();
        this.authorize = config.authorize();
        this.combined = config.combined();
        this.queryParamHandlers.addAll(config.queryParams());
        config.config().ifPresent(conf -> ((List)conf.asNodeList().get()).forEach(node -> this.configMap.put(node.name(), (Config)node)));
    }

    public static SecurityHandlerConfig.Builder builder() {
        return SecurityHandlerConfig.builder();
    }

    public static SecurityHandler create(Consumer<SecurityHandlerConfig.Builder> consumer) {
        return ((SecurityHandlerConfig.Builder)SecurityHandler.builder().update(consumer)).build();
    }

    public static SecurityHandler create(Config config, SecurityHandler defaults) {
        return ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(defaults.prototype())).config(config)).build();
    }

    static SecurityHandler create(SecurityHandlerConfig config) {
        return new SecurityHandler(config);
    }

    static SecurityHandler create() {
        return DEFAULT_INSTANCE;
    }

    public void handle(ServerRequest req, ServerResponse res) {
        Context context = Contexts.context().orElseGet(() -> ((ServerRequest)req).context());
        SecurityContext securityContext = (SecurityContext)context.get(SecurityContext.class).orElseThrow(() -> new SecurityException("Security context not present. The security feature must be applied on this socket."));
        if (this.combined) {
            this.processSecurity(securityContext, req, res);
        } else {
            if (null == this.combinedHandler.get()) {
                SecurityHandler defaultHandler = context.get(SecurityHandler.class).orElse(DEFAULT_INSTANCE);
                if (defaultHandler == DEFAULT_INSTANCE) {
                    this.combinedHandler.set(this);
                } else {
                    this.combinedHandler.compareAndSet(null, ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(defaultHandler.prototype())).from(this.prototype())).combined(true)).build());
                }
            }
            this.combinedHandler.get().processSecurity(securityContext, req, res);
        }
    }

    public SecurityHandlerConfig prototype() {
        return this.config;
    }

    public List<QueryParamHandler> queryParamHandlers() {
        return Collections.unmodifiableList(this.queryParamHandlers);
    }

    public SecurityHandler authenticator(String explicitAuthenticator) {
        return ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(this.prototype())).authenticator(explicitAuthenticator)).build();
    }

    public SecurityHandler authorizer(String explicitAuthorizer) {
        return ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(this.prototype())).authorizer(explicitAuthorizer)).build();
    }

    public SecurityHandler rolesAllowed(String ... roles) {
        return ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(this.prototype())).rolesAllowed(Set.of(roles))).authorize(true)).authenticate(true)).build();
    }

    public SecurityHandler authenticationOptional() {
        return ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(this.prototype())).authenticationOptional(true)).build();
    }

    public SecurityHandler authenticate() {
        return ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(this.prototype())).authenticate(true)).build();
    }

    public SecurityHandler skipAuthentication() {
        return ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(this.prototype())).authenticate(false)).build();
    }

    public SecurityHandler customObject(Object object) {
        return ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(this.prototype())).addObject(object)).build();
    }

    public SecurityHandler auditEventType(String eventType) {
        return ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(this.prototype())).auditEventType(eventType)).build();
    }

    public SecurityHandler auditMessageFormat(String messageFormat) {
        return ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(this.prototype())).auditMessageFormat(messageFormat)).build();
    }

    public SecurityHandler authorize() {
        return ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(this.prototype())).authorize(true)).build();
    }

    public SecurityHandler skipAuthorization() {
        return ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(this.prototype())).authorize(false)).build();
    }

    public SecurityHandler audit() {
        return ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(this.prototype())).audit(true)).build();
    }

    public SecurityHandler skipAudit() {
        return ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(this.prototype())).audit(false)).build();
    }

    public SecurityHandler queryParam(String queryParamName, TokenHandler headerHandler) {
        return ((SecurityHandlerConfig.Builder)((SecurityHandlerConfig.Builder)SecurityHandler.builder().from(this.prototype())).addQueryParam(QueryParamHandler.create(queryParamName, headerHandler))).build();
    }

    void extractQueryParams(SecurityContext securityContext, ServerRequest req) {
        HashMap headers = new HashMap();
        this.queryParamHandlers.forEach(handler -> handler.extract(req, headers));
        securityContext.env(securityContext.env().derive().headers(headers).build());
    }

    private static <T> void configure(Config config, String key, Optional<T> defaultValue, Consumer<T> builderMethod, Class<T> clazz) {
        config.get(key).as(clazz).or(() -> defaultValue).ifPresent(builderMethod);
    }

    private void processSecurity(SecurityContext securityContext, ServerRequest req, ServerResponse res) {
        SecurityTracing tracing = SecurityTracing.get();
        tracing.securityContext(securityContext);
        this.extractQueryParams(securityContext, req);
        securityContext.endpointConfig(securityContext.endpointConfig().derive().configMap(this.configMap).customObjects(this.customObjects.orElse((ClassToInstanceStore<Object>)new ClassToInstanceStore())).build());
        try {
            AtxResult atnResult = this.processAuthentication(res, securityContext, tracing.atnTracing());
            AtxResult atzResult = atnResult.proceed ? this.processAuthorization(req, res, securityContext, tracing.atzTracing()) : AtxResult.STOP;
            if (atzResult.proceed) {
                tracing.logProceed();
                tracing.finish();
                res.next();
            } else {
                tracing.logDeny();
                tracing.finish();
            }
        }
        catch (Exception e) {
            tracing.error((Throwable)e);
            LOGGER.log(System.Logger.Level.ERROR, "Unexpected exception during security processing", (Throwable)e);
            this.abortRequest(res, null, Status.INTERNAL_SERVER_ERROR_500.code(), Map.of());
        }
        res.whenSent(() -> this.processAudit(req, res, securityContext));
    }

    private void processAudit(ServerRequest req, ServerResponse res, SecurityContext securityContext) {
        Method method = req.prologue().method();
        if (!this.audited.orElse(true).booleanValue()) {
            return;
        }
        if (this.audited.isEmpty() && (method == Method.GET || method == Method.HEAD)) {
            return;
        }
        SecurityAuditEvent auditEvent = SecurityAuditEvent.audit((AuditEvent.AuditSeverity)(switch (res.status().family()) {
            case Status.Family.INFORMATIONAL, Status.Family.SUCCESSFUL, Status.Family.REDIRECTION -> AuditEvent.AuditSeverity.SUCCESS;
            default -> AuditEvent.AuditSeverity.FAILURE;
        }), (String)this.auditEventType.orElse(DEFAULT_AUDIT_EVENT_TYPE), (String)this.auditMessageFormat.orElse(DEFAULT_AUDIT_MESSAGE_FORMAT)).addParam(AuditEvent.AuditParam.plain((String)"method", (Object)method)).addParam(AuditEvent.AuditParam.plain((String)"path", (Object)req.path())).addParam(AuditEvent.AuditParam.plain((String)"status", (Object)String.valueOf(res.status().code()))).addParam(AuditEvent.AuditParam.plain((String)"subject", (Object)securityContext.user().orElse(SecurityContext.ANONYMOUS))).addParam(AuditEvent.AuditParam.plain((String)"transport", (Object)"http")).addParam(AuditEvent.AuditParam.plain((String)"resourceType", (Object)"http")).addParam(AuditEvent.AuditParam.plain((String)"targetUri", (Object)req.prologue().uriPath().rawPath()));
        securityContext.service().ifPresent(svc -> auditEvent.addParam(AuditEvent.AuditParam.plain((String)"service", (Object)svc.toString())));
        securityContext.audit((AuditEvent)auditEvent);
    }

    private AtxResult processAuthentication(ServerResponse res, SecurityContext securityContext, AtnTracing atnTracing) {
        if (!this.authenticate.orElse(false).booleanValue()) {
            return AtxResult.PROCEED;
        }
        SecurityClientBuilder clientBuilder = securityContext.atnClientBuilder();
        this.configureSecurityRequest((SecurityRequestBuilder<? extends SecurityRequestBuilder<?>>)clientBuilder, atnTracing.findParent().orElse(null));
        try {
            AuthenticationResponse response = (AuthenticationResponse)((SecurityClientBuilder)clientBuilder.explicitProvider((String)this.explicitAuthenticator.orElse(null))).submit();
            response.responseHeaders().forEach((key, value) -> res.headers().set(HeaderValues.create((String)key, (Collection)value)));
            switch (response.status()) {
                case SUCCESS: {
                    break;
                }
                case FAILURE_FINISH: {
                    if (!this.atnFinishFailure(res, response)) break;
                    this.atnSpanFinish(atnTracing, response);
                    return AtxResult.STOP;
                }
                case SUCCESS_FINISH: {
                    this.atnFinish(res, response);
                    this.atnSpanFinish(atnTracing, response);
                    return AtxResult.STOP;
                }
                case ABSTAIN: 
                case FAILURE: {
                    if (!this.atnAbstainFailure(res, response)) break;
                    this.atnSpanFinish(atnTracing, response);
                    return AtxResult.STOP;
                }
                default: {
                    throw new SecurityException("Invalid SecurityStatus returned: " + String.valueOf(response.status()));
                }
            }
            this.atnSpanFinish(atnTracing, response);
            return new AtxResult(clientBuilder.buildRequest());
        }
        catch (Exception e) {
            atnTracing.error((Throwable)e);
            throw e;
        }
    }

    private void atnSpanFinish(AtnTracing atnTracing, AuthenticationResponse response) {
        response.user().ifPresent(arg_0 -> ((AtnTracing)atnTracing).logUser(arg_0));
        response.service().ifPresent(arg_0 -> ((AtnTracing)atnTracing).logService(arg_0));
        atnTracing.logStatus(response.status());
        atnTracing.finish();
    }

    private boolean atnAbstainFailure(ServerResponse res, AuthenticationResponse response) {
        if (this.authenticationOptional.orElse(false).booleanValue()) {
            LOGGER.log(System.Logger.Level.TRACE, "Authentication failed, but was optional, so assuming anonymous");
            return false;
        }
        this.abortRequest(res, (SecurityResponse)response, Status.UNAUTHORIZED_401.code(), Map.of(HeaderNames.WWW_AUTHENTICATE, List.of("Basic realm=\"Security Realm\"")));
        return true;
    }

    private boolean atnFinishFailure(ServerResponse res, AuthenticationResponse response) {
        if (this.authenticationOptional.orElse(false).booleanValue()) {
            LOGGER.log(System.Logger.Level.TRACE, "Authentication failed, but was optional, so assuming anonymous");
            return false;
        }
        int defaultStatusCode = Status.UNAUTHORIZED_401.code();
        this.abortRequest(res, (SecurityResponse)response, defaultStatusCode, Map.of());
        return true;
    }

    private void atnFinish(ServerResponse res, AuthenticationResponse response) {
        int defaultStatusCode = Status.OK_200.code();
        this.abortRequest(res, (SecurityResponse)response, defaultStatusCode, Map.of());
    }

    private void abortRequest(ServerResponse res, SecurityResponse response, int defaultCode, Map<HeaderName, List<String>> defaultHeaders) {
        Map<HeaderName, List<String>> responseHeaders;
        int statusCode;
        int n = statusCode = null == response ? defaultCode : response.statusCode().orElse(defaultCode);
        if (response == null) {
            responseHeaders = defaultHeaders;
        } else {
            HashMap<HeaderName, List<String>> tmpHeaders = new HashMap<HeaderName, List<String>>();
            response.responseHeaders().forEach((key, value) -> tmpHeaders.put(HeaderNames.create((String)key), (List<String>)value));
            responseHeaders = tmpHeaders;
        }
        responseHeaders = responseHeaders.isEmpty() ? defaultHeaders : responseHeaders;
        ServerResponseHeaders httpHeaders = res.headers();
        for (Map.Entry<HeaderName, List<String>> entry : responseHeaders.entrySet()) {
            httpHeaders.set(entry.getKey(), (Collection)entry.getValue());
        }
        res.status(Status.create((int)statusCode));
        res.send();
    }

    private void configureSecurityRequest(SecurityRequestBuilder<? extends SecurityRequestBuilder<?>> request, SpanContext parentSpanContext) {
        request.optional(this.authenticationOptional.orElse(false).booleanValue()).tracingSpan(parentSpanContext);
    }

    private AtxResult processAuthorization(ServerRequest req, ServerResponse res, SecurityContext context, AtzTracing atzTracing) {
        if (!this.authorize.orElse(false).booleanValue()) {
            atzTracing.logStatus(SecurityResponse.SecurityStatus.ABSTAIN);
            atzTracing.finish();
            return AtxResult.PROCEED;
        }
        Set<String> rolesSet = this.rolesAllowed.orElse(Set.of());
        if (!rolesSet.isEmpty()) {
            if (this.explicitAuthorizer.isPresent()) {
                if (rolesSet.stream().noneMatch(role -> context.isUserInRole(role, this.explicitAuthorizer.get()))) {
                    this.auditRoleMissing(context, req.path(), context.user(), rolesSet);
                    this.abortRequest(res, null, Status.FORBIDDEN_403.code(), Map.of());
                    atzTracing.finish();
                    return AtxResult.STOP;
                }
            } else if (rolesSet.stream().noneMatch(arg_0 -> ((SecurityContext)context).isUserInRole(arg_0))) {
                this.auditRoleMissing(context, req.path(), context.user(), rolesSet);
                this.abortRequest(res, null, Status.FORBIDDEN_403.code(), Map.of());
                atzTracing.finish();
                return AtxResult.STOP;
            }
        }
        SecurityClientBuilder client = context.atzClientBuilder();
        this.configureSecurityRequest((SecurityRequestBuilder<? extends SecurityRequestBuilder<?>>)client, atzTracing.findParent().orElse(null));
        try {
            AuthorizationResponse response = (AuthorizationResponse)((SecurityClientBuilder)client.explicitProvider((String)this.explicitAuthorizer.orElse(null))).submit();
            atzTracing.logStatus(response.status());
            switch (response.status()) {
                case SUCCESS: {
                    break;
                }
                case FAILURE_FINISH: 
                case SUCCESS_FINISH: {
                    int defaultStatus = response.status() == SecurityResponse.SecurityStatus.FAILURE_FINISH ? Status.FORBIDDEN_403.code() : Status.OK_200.code();
                    atzTracing.finish();
                    this.abortRequest(res, (SecurityResponse)response, defaultStatus, Map.of());
                    return AtxResult.STOP;
                }
                case ABSTAIN: 
                case FAILURE: {
                    atzTracing.finish();
                    this.abortRequest(res, (SecurityResponse)response, Status.FORBIDDEN_403.code(), Map.of());
                    return AtxResult.STOP;
                }
                default: {
                    throw new SecurityException("Invalid SecurityStatus returned: " + String.valueOf(response.status()));
                }
            }
            atzTracing.finish();
            return AtxResult.PROCEED;
        }
        catch (Exception e) {
            atzTracing.error((Throwable)e);
            throw e;
        }
    }

    private void auditRoleMissing(SecurityContext context, RoutedPath path, Optional<Subject> user, Set<String> rolesSet) {
        context.audit((AuditEvent)SecurityAuditEvent.failure((String)"authz.authorize", (String)"User is not in any of the required roles: %s. Path %s. Subject %s").addParam(AuditEvent.AuditParam.plain((String)"roles", rolesSet)).addParam(AuditEvent.AuditParam.plain((String)"path", (Object)path)).addParam(AuditEvent.AuditParam.plain((String)"subject", user)));
    }

    public static final class QueryParamHandler {
        private final String queryParamName;
        private final TokenHandler headerHandler;

        private QueryParamHandler(QueryParamMapping mapping) {
            this.queryParamName = mapping.queryParamName();
            this.headerHandler = mapping.tokenHandler();
        }

        public static QueryParamHandler create(Config config) {
            return QueryParamHandler.create(QueryParamMapping.create((Config)config));
        }

        public static QueryParamHandler create(QueryParamMapping mapping) {
            return new QueryParamHandler(mapping);
        }

        public static QueryParamHandler create(String queryParamName, TokenHandler headerHandler) {
            return QueryParamHandler.create(QueryParamMapping.create((String)queryParamName, (TokenHandler)headerHandler));
        }

        void extract(ServerRequest req, Map<String, List<String>> headers) {
            UriQuery uriQuery = req.query();
            if (uriQuery.contains(this.queryParamName)) {
                List values = uriQuery.all(this.queryParamName);
                values.forEach(token -> {
                    String tokenValue = this.headerHandler.extractToken(token);
                    this.headerHandler.addHeader(headers, tokenValue);
                });
            }
        }
    }

    private static final class AtxResult {
        private static final AtxResult PROCEED = new AtxResult(true);
        private static final AtxResult STOP = new AtxResult(false);
        private final boolean proceed;

        private AtxResult(boolean proceed) {
            this.proceed = proceed;
        }

        private AtxResult(SecurityRequest ignored) {
            this.proceed = true;
        }
    }
}

