/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.builder.api.RuntimeType;
import io.helidon.webserver.staticcontent.CachedHandlerInMemory;
import io.helidon.webserver.staticcontent.MemoryCacheConfig;
import io.helidon.webserver.staticcontent.StaticContentHandler;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Supplier;

@RuntimeType.PrototypedBy(value=MemoryCacheConfig.class)
public class MemoryCache
implements RuntimeType.Api<MemoryCacheConfig> {
    private final MemoryCacheConfig config;
    private final long maxSize;
    private final Map<StaticContentHandler, Map<String, CachedHandlerInMemory>> cache = new IdentityHashMap<StaticContentHandler, Map<String, CachedHandlerInMemory>>();
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private final ReentrantLock sizeLock = new ReentrantLock();
    private long currentSize;

    private MemoryCache(MemoryCacheConfig config) {
        long configuredMax;
        this.config = config;
        this.maxSize = config.enabled() ? ((configuredMax = config.capacity().toBytes()) == 0L ? Long.MAX_VALUE : configuredMax) : 0L;
    }

    public static MemoryCacheConfig.Builder builder() {
        return MemoryCacheConfig.builder();
    }

    public static MemoryCache create(MemoryCacheConfig config) {
        return new MemoryCache(config);
    }

    public static MemoryCache create(Consumer<MemoryCacheConfig.Builder> consumer) {
        return ((MemoryCacheConfig.Builder)MemoryCache.builder().update(consumer)).build();
    }

    public static MemoryCache create() {
        return ((MemoryCacheConfig.Builder)MemoryCache.builder().enabled(false)).build();
    }

    public MemoryCacheConfig prototype() {
        return this.config;
    }

    void clear(StaticContentHandler staticContentHandler) {
        try {
            this.cacheLock.writeLock().lock();
            this.cache.remove(staticContentHandler);
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    boolean available(int bytes) {
        return this.maxSize != 0L && this.currentSize + (long)bytes <= this.maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<CachedHandlerInMemory> cache(StaticContentHandler handler, String resource, int size, Supplier<CachedHandlerInMemory> handlerSupplier) {
        try {
            this.sizeLock.lock();
            if (this.maxSize == 0L || this.currentSize + (long)size > this.maxSize) {
                Optional<CachedHandlerInMemory> optional = Optional.empty();
                return optional;
            }
            this.currentSize += (long)size;
        }
        finally {
            this.sizeLock.unlock();
        }
        try {
            this.cacheLock.writeLock().lock();
            CachedHandlerInMemory cachedHandlerInMemory = handlerSupplier.get();
            this.cache.computeIfAbsent(handler, k -> new HashMap()).put(resource, cachedHandlerInMemory);
            Optional<CachedHandlerInMemory> optional = Optional.of(cachedHandlerInMemory);
            return optional;
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cache(StaticContentHandler handler, String resource, CachedHandlerInMemory inMemoryHandler) {
        try {
            this.sizeLock.lock();
            if (this.maxSize != 0L) {
                this.currentSize += (long)inMemoryHandler.contentLength();
            }
        }
        finally {
            this.sizeLock.unlock();
        }
        try {
            this.cacheLock.writeLock().lock();
            this.cache.computeIfAbsent(handler, k -> new HashMap()).put(resource, inMemoryHandler);
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<CachedHandlerInMemory> get(StaticContentHandler handler, String resource) {
        try {
            this.cacheLock.readLock().lock();
            Map<String, CachedHandlerInMemory> resourceCache = this.cache.get(handler);
            if (resourceCache == null) {
                Optional<CachedHandlerInMemory> optional = Optional.empty();
                return optional;
            }
            Optional<CachedHandlerInMemory> optional = Optional.ofNullable(resourceCache.get(resource));
            return optional;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }
}

