/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.ServerRequestHeaders;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.webserver.http.ServerRequest;
import io.helidon.webserver.http.ServerResponse;
import io.helidon.webserver.staticcontent.BaseHandlerConfig;
import io.helidon.webserver.staticcontent.ByteRangeRequest;
import io.helidon.webserver.staticcontent.CachedHandler;
import io.helidon.webserver.staticcontent.CachedHandlerPath;
import io.helidon.webserver.staticcontent.StaticContentHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

abstract class FileBasedContentHandler
extends StaticContentHandler {
    private final Map<String, MediaType> customMediaTypes;

    FileBasedContentHandler(BaseHandlerConfig config) {
        super(config);
        this.customMediaTypes = config.contentTypes();
    }

    static String fileName(Path path) {
        Path fileName = path.getFileName();
        if (null == fileName) {
            return "";
        }
        return fileName.toString();
    }

    static void processContentLength(Path path, ServerResponseHeaders headers) {
        headers.set(HeaderValues.create((HeaderName)HeaderNames.CONTENT_LENGTH, (long)FileBasedContentHandler.contentLength(path)));
    }

    static long contentLength(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static void send(ServerRequest request, ServerResponse response, Path path) throws IOException {
        block39: {
            ServerRequestHeaders headers = request.headers();
            if (headers.contains(HeaderNames.RANGE)) {
                long contentLength = FileBasedContentHandler.contentLength(path);
                List<ByteRangeRequest> ranges = ByteRangeRequest.parse(request, response, headers.get(HeaderNames.RANGE).values(), contentLength);
                if (ranges.size() == 1) {
                    ByteRangeRequest range = ranges.getFirst();
                    range.setContentRange(response);
                    try (OutputStream out = response.outputStream();
                         SeekableByteChannel channel = Files.newByteChannel(path, new OpenOption[0]);){
                        int toWrite;
                        long toRead;
                        WritableByteChannel outChannel = Channels.newChannel(out);
                        channel.position(range.offset());
                        ByteBuffer buffer = ByteBuffer.allocate((int)Math.min(toRead, 1000L));
                        for (toRead = range.length(); toRead != 0L; toRead -= (long)toWrite) {
                            int read = channel.read(buffer);
                            toWrite = (int)Math.min(toRead, (long)read);
                            buffer.flip();
                            buffer.limit(toWrite);
                            outChannel.write(buffer);
                            buffer.flip();
                        }
                        break block39;
                    }
                }
                FileBasedContentHandler.processContentLength(path, response.headers());
                try (InputStream in = Files.newInputStream(path, new OpenOption[0]);
                     OutputStream out = response.outputStream();){
                    in.transferTo(out);
                    break block39;
                }
            }
            FileBasedContentHandler.processContentLength(path, response.headers());
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);
                 OutputStream out = response.outputStream();){
                in.transferTo(out);
            }
        }
    }

    Optional<MediaType> findCustomMediaType(String fileName) {
        int ind = fileName.lastIndexOf(46);
        if (ind < 0) {
            return Optional.empty();
        }
        String fileSuffix = fileName.substring(ind + 1);
        return Optional.ofNullable(this.customMediaTypes.get(fileSuffix));
    }

    Optional<CachedHandler> fileHandler(Path path) {
        return Optional.of(new CachedHandlerPath(path, this.detectType(FileBasedContentHandler.fileName(path)), FileBasedContentHandler::lastModified, ServerResponseHeaders::lastModified));
    }

    MediaType detectType(String fileName) {
        Objects.requireNonNull(fileName);
        return this.findCustomMediaType(fileName).or(() -> MediaTypes.detectType((String)fileName)).orElse(MediaTypes.APPLICATION_OCTET_STREAM);
    }

    static Optional<Instant> lastModified(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            return Optional.of(Files.getLastModifiedTime(path, new LinkOption[0]).toInstant());
        }
        return Optional.empty();
    }

    static Path resolveWelcomeFile(Path directory, String name) {
        FileBasedContentHandler.throwNotFoundIf(name == null || name.isEmpty());
        Path result = directory.resolve(name);
        FileBasedContentHandler.throwNotFoundIf(!Files.exists(result, new LinkOption[0]));
        return result;
    }
}

