/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.builder.api.Prototype;
import io.helidon.common.config.Config;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.webserver.staticcontent.ClasspathHandlerConfig;
import io.helidon.webserver.staticcontent.FileSystemHandlerConfig;
import java.nio.file.Path;

final class StaticContentConfigSupport {
    private StaticContentConfigSupport() {
    }

    private static MediaType createContentTypes(Config config) {
        return (MediaType)config.asString().map(MediaTypes::create).get();
    }

    static class StaticContentMethods {
        private StaticContentMethods() {
        }

        @Prototype.FactoryMethod
        static MediaType createContentTypes(Config config) {
            return StaticContentConfigSupport.createContentTypes(config);
        }
    }

    static class ClasspathMethods {
        private ClasspathMethods() {
        }

        @Prototype.FactoryMethod
        static ClasspathHandlerConfig create(String location) {
            return ((ClasspathHandlerConfig.Builder)ClasspathHandlerConfig.builder().location(location)).build();
        }
    }

    static class FileSystemMethods {
        private FileSystemMethods() {
        }

        @Prototype.FactoryMethod
        static FileSystemHandlerConfig create(Path location) {
            return ((FileSystemHandlerConfig.Builder)FileSystemHandlerConfig.builder().location(location)).build();
        }
    }

    static class BaseMethods {
        private BaseMethods() {
        }

        @Prototype.FactoryMethod
        static MediaType createContentTypes(Config config) {
            return StaticContentConfigSupport.createContentTypes(config);
        }
    }
}

