/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.staticcontent;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.Weighted;
import io.helidon.common.media.type.MediaType;
import io.helidon.config.Config;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.spi.ServerFeature;
import io.helidon.webserver.staticcontent.ClassPathContentHandler;
import io.helidon.webserver.staticcontent.ClasspathHandlerConfig;
import io.helidon.webserver.staticcontent.FileSystemContentHandler;
import io.helidon.webserver.staticcontent.FileSystemHandlerConfig;
import io.helidon.webserver.staticcontent.MemoryCache;
import io.helidon.webserver.staticcontent.StaticContentConfig;
import io.helidon.webserver.staticcontent.TemporaryStorage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=StaticContentConfig.class)
public class StaticContentFeature
implements Weighted,
ServerFeature,
RuntimeType.Api<StaticContentConfig> {
    static final String STATIC_CONTENT_ID = "static-content";
    static final double WEIGHT = 95.0;
    private static final System.Logger LOGGER = System.getLogger(StaticContentFeature.class.getName());
    private final StaticContentConfig config;
    private final MemoryCache memoryCache;
    private final TemporaryStorage temporaryStorage;
    private final Map<String, MediaType> contentTypeMapping;
    private final boolean enabled;
    private final Set<String> sockets;
    private final Optional<String> welcome;

    private StaticContentFeature(StaticContentConfig config) {
        this.config = config;
        boolean bl = this.enabled = config.enabled() && (!config.classpath().isEmpty() || !config.path().isEmpty());
        if (this.enabled) {
            this.contentTypeMapping = config.contentTypes();
            this.memoryCache = config.memoryCache().orElseGet(MemoryCache::create);
            this.sockets = config.sockets();
            this.welcome = config.welcome();
            this.temporaryStorage = config.classpath().isEmpty() ? null : config.temporaryStorage().orElseGet(TemporaryStorage::create);
        } else {
            this.sockets = Set.of();
            this.welcome = Optional.empty();
            this.memoryCache = null;
            this.temporaryStorage = null;
            this.contentTypeMapping = null;
        }
    }

    public static StaticContentFeature create(Config config) {
        return ((StaticContentConfig.Builder)StaticContentFeature.builder().config((io.helidon.common.config.Config)config)).build();
    }

    public static StaticContentConfig.Builder builder() {
        return StaticContentConfig.builder();
    }

    public static StaticContentFeature create(StaticContentConfig config) {
        return new StaticContentFeature(config);
    }

    public static StaticContentFeature create(Consumer<StaticContentConfig.Builder> builderConsumer) {
        return ((StaticContentConfig.Builder)StaticContentFeature.builder().update(builderConsumer)).build();
    }

    public static HttpService createService(FileSystemHandlerConfig config) {
        return FileSystemContentHandler.create(config);
    }

    public static HttpService createService(ClasspathHandlerConfig config) {
        return ClassPathContentHandler.create(config);
    }

    public StaticContentConfig prototype() {
        return this.config;
    }

    public String name() {
        return this.config.name();
    }

    public String type() {
        return STATIC_CONTENT_ID;
    }

    public double weight() {
        return this.config.weight();
    }

    /*
     * WARNING - void declaration
     */
    public void setup(ServerFeature.ServerFeatureContext featureContext) {
        MemoryCache handlerCache;
        Set<Object> handlerSockets;
        HashSet<Object> defaultSockets;
        if (!this.enabled) {
            return;
        }
        if (this.sockets.isEmpty()) {
            defaultSockets = new HashSet(featureContext.sockets());
            defaultSockets.add("@default");
        } else {
            defaultSockets = new HashSet<String>(this.sockets);
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        for (ClasspathHandlerConfig classpathHandlerConfig : this.config.classpath()) {
            if (!classpathHandlerConfig.enabled()) continue;
            handlerSockets = classpathHandlerConfig.sockets().isEmpty() ? defaultSockets : classpathHandlerConfig.sockets();
            handlerCache = classpathHandlerConfig.memoryCache().orElse(this.memoryCache);
            TemporaryStorage handlerTmpStorage = classpathHandlerConfig.temporaryStorage().orElse(this.temporaryStorage);
            ClassLoader handlerClassLoader = classpathHandlerConfig.classLoader().orElse(contextClassLoader);
            Optional<String> optional = classpathHandlerConfig.welcome().or(() -> this.welcome);
            HashMap<String, MediaType> contentTypeMap = new HashMap<String, MediaType>(this.contentTypeMapping);
            contentTypeMap.putAll(classpathHandlerConfig.contentTypes());
            for (String string : handlerSockets) {
                void var5_5;
                if (!featureContext.socketExists(string)) {
                    LOGGER.log(System.Logger.Level.WARNING, "Static content handler is configured for socket \"" + string + "\" that is not configured on the server");
                    continue;
                }
                ClasspathHandlerConfig classpathHandlerConfig2 = ((ClasspathHandlerConfig.Builder)((ClasspathHandlerConfig.Builder)((ClasspathHandlerConfig.Builder)((ClasspathHandlerConfig.Builder)((ClasspathHandlerConfig.Builder)((ClasspathHandlerConfig.Builder)ClasspathHandlerConfig.builder().from((ClasspathHandlerConfig)var5_5)).memoryCache(handlerCache)).temporaryStorage(handlerTmpStorage)).update(it -> welcome.ifPresent(it::welcome))).classLoader(handlerClassLoader)).contentTypes(contentTypeMap)).build();
                HttpService service = StaticContentFeature.createService(classpathHandlerConfig2);
                featureContext.socket(string).httpRouting().register(classpathHandlerConfig2.context(), new HttpService[]{service});
            }
        }
        for (FileSystemHandlerConfig fileSystemHandlerConfig : this.config.path()) {
            if (!fileSystemHandlerConfig.enabled()) continue;
            handlerSockets = fileSystemHandlerConfig.sockets().isEmpty() ? defaultSockets : fileSystemHandlerConfig.sockets();
            handlerCache = fileSystemHandlerConfig.memoryCache().orElse(this.memoryCache);
            HashMap<String, MediaType> contentTypeMap = new HashMap<String, MediaType>(this.contentTypeMapping);
            contentTypeMap.putAll(fileSystemHandlerConfig.contentTypes());
            for (String string : handlerSockets) {
                void var5_10;
                if (!featureContext.socketExists(string)) {
                    LOGGER.log(System.Logger.Level.WARNING, "Static content handler is configured for socket \"" + string + "\" that is not configured on the server");
                    continue;
                }
                FileSystemHandlerConfig fileSystemHandlerConfig2 = ((FileSystemHandlerConfig.Builder)((FileSystemHandlerConfig.Builder)((FileSystemHandlerConfig.Builder)FileSystemHandlerConfig.builder().from((FileSystemHandlerConfig)var5_10)).memoryCache(handlerCache)).contentTypes(contentTypeMap)).build();
                HttpService service = StaticContentFeature.createService(fileSystemHandlerConfig2);
                featureContext.socket(string).httpRouting().register(fileSystemHandlerConfig2.context(), new HttpService[]{service});
            }
        }
    }
}

